// services/device/public/mojom/hid.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace device::mojom {
namespace internal {
class HidUsageAndPage_Data;
class HidReportItem_Data;
class HidReportDescription_Data;
class HidCollectionInfo_Data;
class HidDeviceInfo_Data;

struct HidBusType_Data {
 public:
  static bool constexpr kIsExtensible = true;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  HidUsageAndPage_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint16_t usage;
  uint16_t usage_page;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<HidUsageAndPage_Data>;

  HidUsageAndPage_Data();
  ~HidUsageAndPage_Data() = delete;
};
static_assert(sizeof(HidUsageAndPage_Data) == 16,
              "Bad sizeof(HidUsageAndPage_Data)");
// Used by HidUsageAndPage::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct HidUsageAndPage_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  HidUsageAndPage_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~HidUsageAndPage_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<HidUsageAndPage_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    HidUsageAndPage_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  HidReportItem_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_range : 1;
  uint8_t is_constant : 1;
  uint8_t is_variable : 1;
  uint8_t is_relative : 1;
  uint8_t wrap : 1;
  uint8_t is_non_linear : 1;
  uint8_t no_preferred_state : 1;
  uint8_t has_null_position : 1;
  uint8_t is_volatile : 1;
  uint8_t is_buffered_bytes : 1;
  uint8_t pad9_[2];
  uint32_t designator_minimum;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::HidUsageAndPage_Data>>> usages;
  mojo::internal::Pointer<internal::HidUsageAndPage_Data> usage_minimum;
  mojo::internal::Pointer<internal::HidUsageAndPage_Data> usage_maximum;
  uint32_t designator_maximum;
  uint32_t string_minimum;
  uint32_t string_maximum;
  int32_t logical_minimum;
  int32_t logical_maximum;
  int32_t physical_minimum;
  int32_t physical_maximum;
  uint32_t unit_exponent;
  uint32_t unit;
  uint32_t report_size;
  uint32_t report_count;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<HidReportItem_Data>;

  HidReportItem_Data();
  ~HidReportItem_Data() = delete;
};
static_assert(sizeof(HidReportItem_Data) == 88,
              "Bad sizeof(HidReportItem_Data)");
// Used by HidReportItem::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct HidReportItem_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  HidReportItem_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~HidReportItem_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<HidReportItem_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    HidReportItem_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  HidReportDescription_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t report_id;
  uint8_t pad0_[7];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::HidReportItem_Data>>> items;

 private:
  friend class mojo::internal::MessageFragment<HidReportDescription_Data>;

  HidReportDescription_Data();
  ~HidReportDescription_Data() = delete;
};
static_assert(sizeof(HidReportDescription_Data) == 24,
              "Bad sizeof(HidReportDescription_Data)");
// Used by HidReportDescription::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct HidReportDescription_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  HidReportDescription_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~HidReportDescription_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<HidReportDescription_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    HidReportDescription_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  HidCollectionInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::HidUsageAndPage_Data> usage;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> report_ids;
  uint32_t collection_type;
  uint8_t pad2_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::HidReportDescription_Data>>> input_reports;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::HidReportDescription_Data>>> output_reports;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::HidReportDescription_Data>>> feature_reports;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::HidCollectionInfo_Data>>> children;

 private:
  friend class mojo::internal::MessageFragment<HidCollectionInfo_Data>;

  HidCollectionInfo_Data();
  ~HidCollectionInfo_Data() = delete;
};
static_assert(sizeof(HidCollectionInfo_Data) == 64,
              "Bad sizeof(HidCollectionInfo_Data)");
// Used by HidCollectionInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct HidCollectionInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  HidCollectionInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~HidCollectionInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<HidCollectionInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    HidCollectionInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  HidDeviceInfo_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> guid;
  mojo::internal::Pointer<mojo::internal::String_Data> physical_device_id;
  uint16_t vendor_id;
  uint16_t product_id;
  int32_t bus_type;
  mojo::internal::Pointer<mojo::internal::String_Data> product_name;
  mojo::internal::Pointer<mojo::internal::String_Data> serial_number;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> report_descriptor;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::HidCollectionInfo_Data>>> collections;
  uint8_t has_report_id : 1;
  uint8_t is_excluded_by_blocklist : 1;
  uint8_t pad10_[7];
  uint64_t max_input_report_size;
  uint64_t max_output_report_size;
  uint64_t max_feature_report_size;
  mojo::internal::Pointer<mojo::internal::String_Data> device_node;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> protected_input_report_ids;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> protected_output_report_ids;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> protected_feature_report_ids;

 private:
  friend class mojo::internal::MessageFragment<HidDeviceInfo_Data>;

  HidDeviceInfo_Data();
  ~HidDeviceInfo_Data() = delete;
};
static_assert(sizeof(HidDeviceInfo_Data) == 128,
              "Bad sizeof(HidDeviceInfo_Data)");
// Used by HidDeviceInfo::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct HidDeviceInfo_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  HidDeviceInfo_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~HidDeviceInfo_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<HidDeviceInfo_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    HidDeviceInfo_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_SHARED_INTERNAL_H_