// mojo/public/mojom/base/file_error.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "mojo/public/mojom/base/file_error.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "mojo/public/mojom/base/file_error.mojom-params-data.h"
namespace mojo_base {
namespace mojom {

NOINLINE static const char* FileErrorToStringHelper(FileError value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case FileError::IO:
      return "IO";
    case FileError::INVALID_URL:
      return "INVALID_URL";
    case FileError::NOT_EMPTY:
      return "NOT_EMPTY";
    case FileError::NOT_A_FILE:
      return "NOT_A_FILE";
    case FileError::ABORT:
      return "ABORT";
    case FileError::SECURITY:
      return "SECURITY";
    case FileError::INVALID_OPERATION:
      return "INVALID_OPERATION";
    case FileError::NOT_A_DIRECTORY:
      return "NOT_A_DIRECTORY";
    case FileError::NO_SPACE:
      return "NO_SPACE";
    case FileError::NO_MEMORY:
      return "NO_MEMORY";
    case FileError::TOO_MANY_OPENED:
      return "TOO_MANY_OPENED";
    case FileError::ACCESS_DENIED:
      return "ACCESS_DENIED";
    case FileError::NOT_FOUND:
      return "NOT_FOUND";
    case FileError::EXISTS:
      return "EXISTS";
    case FileError::IN_USE:
      return "IN_USE";
    case FileError::FAILED:
      return "FAILED";
    case FileError::OK:
      return "OK";
    default:
      return nullptr;
  }
}

std::string FileErrorToString(FileError value) {
  const char *str = FileErrorToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown FileError value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, FileError value) {
  return os << FileErrorToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace mojo_base

namespace perfetto {

// static
void TraceFormatTraits<::mojo_base::mojom::FileError>::WriteIntoTrace(
   perfetto::TracedValue context, ::mojo_base::mojom::FileError value) {
  return std::move(context).WriteString(::mojo_base::mojom::FileErrorToString(value));
}

} // namespace perfetto