// media/capture/mojom/video_capture_buffer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_SHARED_H_
#define MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/capture/mojom/video_capture_buffer.mojom-shared-internal.h"
#include "gpu/ipc/common/mailbox_holder.mojom-shared.h"
#include "gpu/ipc/common/exported_shared_image.mojom-shared.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "media/capture/mojom/video_capture_types.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace media::mojom {
class VideoFrameInfoDataView;

class ReadyBufferDataView;

class SharedImageBufferHandleSetDataView;

class VideoBufferHandleDataView;


}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::VideoFrameInfoDataView> {
  using Data = ::media::mojom::internal::VideoFrameInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::ReadyBufferDataView> {
  using Data = ::media::mojom::internal::ReadyBuffer_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::SharedImageBufferHandleSetDataView> {
  using Data = ::media::mojom::internal::SharedImageBufferHandleSet_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoBufferHandleDataView> {
  using Data = ::media::mojom::internal::VideoBufferHandle_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {


class VideoFrameInfoDataView {
 public:
  VideoFrameInfoDataView() = default;

  VideoFrameInfoDataView(
      internal::VideoFrameInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTimestampDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimestamp(UserType* output) {
    
    auto* pointer = data_->timestamp.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetMetadataDataView(
      ::media::mojom::VideoFrameMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameMetadataDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPixelFormat(UserType* output) const {
    auto data_value = data_->pixel_format;
    return mojo::internal::Deserialize<::media::mojom::VideoCapturePixelFormat>(
        data_value, output);
  }
  ::media::mojom::VideoCapturePixelFormat pixel_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCapturePixelFormat>(data_->pixel_format));
  }
  inline void GetCodedSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodedSize(UserType* output) {
    
    auto* pointer = data_->coded_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetVisibleRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisibleRect(UserType* output) {
    
    auto* pointer = data_->visible_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  bool is_premapped() const {
    return data_->is_premapped;
  }
  inline void GetColorSpaceDataView(
      ::gfx::mojom::ColorSpaceDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColorSpace(UserType* output) {
    
    auto* pointer = data_->color_space.Get();
    return mojo::internal::Deserialize<::gfx::mojom::ColorSpaceDataView>(
        pointer, output, message_);
  }
  inline void GetStridesDataView(
      ::media::mojom::PlaneStridesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStrides(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::PlaneStridesDataView, UserType>(),
    "Attempting to read the optional `strides` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadStrides` instead "
    "of `ReadStrides if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->strides.Get();
    return mojo::internal::Deserialize<::media::mojom::PlaneStridesDataView>(
        pointer, output, message_);
  }
 private:
  internal::VideoFrameInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ReadyBufferDataView {
 public:
  ReadyBufferDataView() = default;

  ReadyBufferDataView(
      internal::ReadyBuffer_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t buffer_id() const {
    return data_->buffer_id;
  }
  inline void GetInfoDataView(
      VideoFrameInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::media::mojom::VideoFrameInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::ReadyBuffer_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SharedImageBufferHandleSetDataView {
 public:
  SharedImageBufferHandleSetDataView() = default;

  SharedImageBufferHandleSetDataView(
      internal::SharedImageBufferHandleSet_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSharedImageDataView(
      ::gpu::mojom::ExportedSharedImageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImage(UserType* output) {
    
    auto* pointer = data_->shared_image.Get();
    return mojo::internal::Deserialize<::gpu::mojom::ExportedSharedImageDataView>(
        pointer, output, message_);
  }
  inline void GetSyncTokenDataView(
      ::gpu::mojom::SyncTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSyncToken(UserType* output) {
    
    auto* pointer = data_->sync_token.Get();
    return mojo::internal::Deserialize<::gpu::mojom::SyncTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedImageBufferHandleSet_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VideoBufferHandleDataView {
 public:
  using Tag = internal::VideoBufferHandle_Data::VideoBufferHandle_Tag;

  VideoBufferHandleDataView() = default;

  VideoBufferHandleDataView(
      internal::VideoBufferHandle_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_unsafe_shmem_region() const { return data_->tag == Tag::kUnsafeShmemRegion; }
  inline void GetUnsafeShmemRegionDataView(
      ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadUnsafeShmemRegion(UserType* output) const {
    
    CHECK(is_unsafe_shmem_region());
    return mojo::internal::Deserialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
        data_->data.f_unsafe_shmem_region.Get(), output, message_);
  }
  bool is_read_only_shmem_region() const { return data_->tag == Tag::kReadOnlyShmemRegion; }
  inline void GetReadOnlyShmemRegionDataView(
      ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReadOnlyShmemRegion(UserType* output) const {
    
    CHECK(is_read_only_shmem_region());
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
        data_->data.f_read_only_shmem_region.Get(), output, message_);
  }
  bool is_shared_image_handle() const { return data_->tag == Tag::kSharedImageHandle; }
  inline void GetSharedImageHandleDataView(
      SharedImageBufferHandleSetDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSharedImageHandle(UserType* output) const {
    
    CHECK(is_shared_image_handle());
    return mojo::internal::Deserialize<::media::mojom::SharedImageBufferHandleSetDataView>(
        data_->data.f_shared_image_handle.Get(), output, message_);
  }
  bool is_gpu_memory_buffer_handle() const { return data_->tag == Tag::kGpuMemoryBufferHandle; }
  inline void GetGpuMemoryBufferHandleDataView(
      ::gfx::mojom::GpuMemoryBufferHandleDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGpuMemoryBufferHandle(UserType* output) const {
    
    CHECK(is_gpu_memory_buffer_handle());
    return mojo::internal::Deserialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
        data_->data.f_gpu_memory_buffer_handle.Get(), output, message_);
  }

 private:
  internal::VideoBufferHandle_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // media::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoFrameInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoFrameInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::VideoFrameInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
        in_timestamp, timestamp_fragment);
    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->timestamp.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in VideoFrameInfo struct");
    decltype(Traits::metadata(input)) in_metadata = Traits::metadata(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metadata)::BaseType> metadata_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::VideoFrameMetadataDataView>(
        in_metadata, metadata_fragment);
    fragment->metadata.Set(
        metadata_fragment.is_null() ? nullptr : metadata_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->metadata.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metadata in VideoFrameInfo struct");
    mojo::internal::Serialize<::media::mojom::VideoCapturePixelFormat>(
        Traits::pixel_format(input), &fragment->pixel_format);
    decltype(Traits::coded_size(input)) in_coded_size = Traits::coded_size(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coded_size)::BaseType> coded_size_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_coded_size, coded_size_fragment);
    fragment->coded_size.Set(
        coded_size_fragment.is_null() ? nullptr : coded_size_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->coded_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coded_size in VideoFrameInfo struct");
    decltype(Traits::visible_rect(input)) in_visible_rect = Traits::visible_rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visible_rect)::BaseType> visible_rect_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
        in_visible_rect, visible_rect_fragment);
    fragment->visible_rect.Set(
        visible_rect_fragment.is_null() ? nullptr : visible_rect_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->visible_rect.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null visible_rect in VideoFrameInfo struct");
    fragment->is_premapped = Traits::is_premapped(input);
    decltype(Traits::color_space(input)) in_color_space = Traits::color_space(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->color_space)::BaseType> color_space_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::ColorSpaceDataView>(
        in_color_space, color_space_fragment);
    fragment->color_space.Set(
        color_space_fragment.is_null() ? nullptr : color_space_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->color_space.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_space in VideoFrameInfo struct");
    decltype(Traits::strides(input)) in_strides = Traits::strides(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->strides)::BaseType> strides_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::PlaneStridesDataView>(
        in_strides, strides_fragment);
    fragment->strides.Set(
        strides_fragment.is_null() ? nullptr : strides_fragment.data());
  }

  static bool Deserialize(::media::mojom::internal::VideoFrameInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoFrameInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::ReadyBufferDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::ReadyBufferDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::ReadyBuffer_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->buffer_id = Traits::buffer_id(input);
    decltype(Traits::info(input)) in_info = Traits::info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->info)::BaseType> info_fragment(
            fragment.message());
    mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
        in_info, info_fragment);
    fragment->info.Set(
        info_fragment.is_null() ? nullptr : info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null info in ReadyBuffer struct");
  }

  static bool Deserialize(::media::mojom::internal::ReadyBuffer_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::ReadyBufferDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SharedImageBufferHandleSetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SharedImageBufferHandleSetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SharedImageBufferHandleSet_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::shared_image(input)) in_shared_image = Traits::shared_image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_image)::BaseType> shared_image_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::ExportedSharedImageDataView>(
        in_shared_image, shared_image_fragment);
    fragment->shared_image.Set(
        shared_image_fragment.is_null() ? nullptr : shared_image_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->shared_image.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null shared_image in SharedImageBufferHandleSet struct");
    decltype(Traits::sync_token(input)) in_sync_token = Traits::sync_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sync_token)::BaseType> sync_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::gpu::mojom::SyncTokenDataView>(
        in_sync_token, sync_token_fragment);
    fragment->sync_token.Set(
        sync_token_fragment.is_null() ? nullptr : sync_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sync_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sync_token in SharedImageBufferHandleSet struct");
  }

  static bool Deserialize(::media::mojom::internal::SharedImageBufferHandleSet_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::SharedImageBufferHandleSetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoBufferHandleDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media::mojom::VideoBufferHandleDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media::mojom::internal::VideoBufferHandle_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::media::mojom::VideoBufferHandleDataView::Tag::kUnsafeShmemRegion: {
        decltype(Traits::unsafe_shmem_region(input))
            in_unsafe_shmem_region = Traits::unsafe_shmem_region(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_unsafe_shmem_region)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::mojo_base::mojom::UnsafeSharedMemoryRegionDataView>(
            in_unsafe_shmem_region, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null unsafe_shmem_region in VideoBufferHandle union");
        fragment->data.f_unsafe_shmem_region.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::media::mojom::VideoBufferHandleDataView::Tag::kReadOnlyShmemRegion: {
        decltype(Traits::read_only_shmem_region(input))
            in_read_only_shmem_region = Traits::read_only_shmem_region(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_read_only_shmem_region)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
            in_read_only_shmem_region, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null read_only_shmem_region in VideoBufferHandle union");
        fragment->data.f_read_only_shmem_region.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::media::mojom::VideoBufferHandleDataView::Tag::kSharedImageHandle: {
        decltype(Traits::shared_image_handle(input))
            in_shared_image_handle = Traits::shared_image_handle(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_shared_image_handle)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::media::mojom::SharedImageBufferHandleSetDataView>(
            in_shared_image_handle, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null shared_image_handle in VideoBufferHandle union");
        fragment->data.f_shared_image_handle.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::media::mojom::VideoBufferHandleDataView::Tag::kGpuMemoryBufferHandle: {
        decltype(Traits::gpu_memory_buffer_handle(input))
            in_gpu_memory_buffer_handle = Traits::gpu_memory_buffer_handle(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_gpu_memory_buffer_handle)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::gfx::mojom::GpuMemoryBufferHandleDataView>(
            in_gpu_memory_buffer_handle, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null gpu_memory_buffer_handle in VideoBufferHandle union");
        fragment->data.f_gpu_memory_buffer_handle.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::media::mojom::internal::VideoBufferHandle_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoBufferHandleDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void VideoFrameInfoDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void VideoFrameInfoDataView::GetMetadataDataView(
    ::media::mojom::VideoFrameMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = ::media::mojom::VideoFrameMetadataDataView(pointer, message_);
}
inline void VideoFrameInfoDataView::GetCodedSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->coded_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void VideoFrameInfoDataView::GetVisibleRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->visible_rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void VideoFrameInfoDataView::GetColorSpaceDataView(
    ::gfx::mojom::ColorSpaceDataView* output) {
  auto pointer = data_->color_space.Get();
  *output = ::gfx::mojom::ColorSpaceDataView(pointer, message_);
}
inline void VideoFrameInfoDataView::GetStridesDataView(
    ::media::mojom::PlaneStridesDataView* output) {
  auto pointer = data_->strides.Get();
  *output = ::media::mojom::PlaneStridesDataView(pointer, message_);
}


inline void ReadyBufferDataView::GetInfoDataView(
    VideoFrameInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = VideoFrameInfoDataView(pointer, message_);
}


inline void SharedImageBufferHandleSetDataView::GetSharedImageDataView(
    ::gpu::mojom::ExportedSharedImageDataView* output) {
  auto pointer = data_->shared_image.Get();
  *output = ::gpu::mojom::ExportedSharedImageDataView(pointer, message_);
}
inline void SharedImageBufferHandleSetDataView::GetSyncTokenDataView(
    ::gpu::mojom::SyncTokenDataView* output) {
  auto pointer = data_->sync_token.Get();
  *output = ::gpu::mojom::SyncTokenDataView(pointer, message_);
}


inline void VideoBufferHandleDataView::GetUnsafeShmemRegionDataView(
    ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView* output) const {
  CHECK(is_unsafe_shmem_region());
  *output = ::mojo_base::mojom::UnsafeSharedMemoryRegionDataView(data_->data.f_unsafe_shmem_region.Get(), message_);
}
inline void VideoBufferHandleDataView::GetReadOnlyShmemRegionDataView(
    ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView* output) const {
  CHECK(is_read_only_shmem_region());
  *output = ::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView(data_->data.f_read_only_shmem_region.Get(), message_);
}
inline void VideoBufferHandleDataView::GetSharedImageHandleDataView(
    SharedImageBufferHandleSetDataView* output) const {
  CHECK(is_shared_image_handle());
  *output = SharedImageBufferHandleSetDataView(data_->data.f_shared_image_handle.Get(), message_);
}
inline void VideoBufferHandleDataView::GetGpuMemoryBufferHandleDataView(
    ::gfx::mojom::GpuMemoryBufferHandleDataView* output) const {
  CHECK(is_gpu_memory_buffer_handle());
  *output = ::gfx::mojom::GpuMemoryBufferHandleDataView(data_->data.f_gpu_memory_buffer_handle.Get(), message_);
}


}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_CAPTURE_MOJOM_VIDEO_CAPTURE_BUFFER_MOJOM_SHARED_H_