/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class EndDeclaration
extends ControlSequence {
    private String declName;

    public EndDeclaration(String string, Declaration declaration) {
        super(string);
        this.declName = declaration.getName();
        declaration.setEndDeclaration(this);
    }

    public EndDeclaration(Declaration declaration) {
        super("end" + declaration.getName());
        this.declName = declaration.getName();
        declaration.setEndDeclaration(this);
    }

    public EndDeclaration(String string) {
        super(string);
        if (string.startsWith("end")) {
            this.declName = string.substring(3);
        } else {
            this.setName("end" + string);
            this.declName = string;
        }
    }

    @Override
    public Object clone() {
        EndDeclaration endDeclaration = new EndDeclaration(this.getName());
        endDeclaration.declName = this.declName;
        return endDeclaration;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.doEnd(teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.doEnd(teXParser, teXParser);
    }

    protected void doEnd(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        Declaration declaration = this.getDeclaration(teXParser);
        if (declaration != null) {
            declaration.end(teXParser, teXObjectList);
        }
    }

    public Declaration getDeclaration(TeXParser teXParser) {
        ControlSequence controlSequence = teXParser.getListener().getControlSequence(this.declName);
        if (controlSequence instanceof Declaration) {
            return (Declaration)controlSequence;
        }
        return null;
    }

    public boolean isModeSwitcher(TeXParser teXParser) {
        Declaration declaration = this.getDeclaration(teXParser);
        return declaration == null ? false : declaration.isModeSwitcher();
    }

    public EndDeclaration getEndDeclaration(TeXParser teXParser) throws IOException {
        return null;
    }

    public void setEndDeclaration(EndDeclaration endDeclaration) {
    }

    public String getDeclarationName() {
        return this.declName;
    }
}

