/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.api.CoordinatorV2HttpSolrCall;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SyntheticSolrCore;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.request.DelegatingSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.servlet.HttpSolrCall;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorHttpSolrCall
extends HttpSolrCall {
    public static final String SYNTHETIC_COLL_PREFIX = ".sys.COORDINATOR-COLL-";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String collectionName;
    private final Factory factory;

    public CoordinatorHttpSolrCall(Factory factory, SolrDispatchFilter solrDispatchFilter, CoreContainer cores, HttpServletRequest request, HttpServletResponse response, boolean retry) {
        super(solrDispatchFilter, cores, request, response, retry);
        this.factory = factory;
    }

    @Override
    protected SolrCore getCoreByCollection(String collectionName, boolean isPreferLeader) {
        this.collectionName = collectionName;
        SolrCore core = super.getCoreByCollection(collectionName, isPreferLeader);
        if (core != null) {
            return core;
        }
        if (!this.path.endsWith("/select")) {
            return null;
        }
        return CoordinatorHttpSolrCall.getCore(this.factory, this, collectionName, isPreferLeader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SolrCore getCore(Factory factory, HttpSolrCall solrCall, String collectionName, boolean isPreferLeader) {
        String syntheticCoreName = factory.collectionVsCoreNameMapping.get(collectionName);
        if (syntheticCoreName != null) {
            SolrCore syntheticCore = solrCall.cores.getCore(syntheticCoreName);
            CoordinatorHttpSolrCall.setMdcLoggingContext(collectionName);
            return syntheticCore;
        }
        ZkStateReader zkStateReader = solrCall.cores.getZkController().getZkStateReader();
        ClusterState clusterState = zkStateReader.getClusterState();
        DocCollection coll = clusterState.getCollectionOrNull(collectionName, true);
        if (coll == null) {
            log.info("Cannot find collection {} to proxy call to, it could have been deleted", (Object)collectionName);
            return null;
        }
        String confName = coll.getConfigName();
        syntheticCoreName = CoordinatorHttpSolrCall.getSyntheticCoreNameFromConfig(confName);
        Class<CoordinatorHttpSolrCall> clazz = CoordinatorHttpSolrCall.class;
        synchronized (CoordinatorHttpSolrCall.class) {
            CoreContainer coreContainer = solrCall.cores;
            SolrCore syntheticCore = coreContainer.getCore(syntheticCoreName);
            if (syntheticCore == null) {
                log.info("Loading synthetic core for config set {}", (Object)confName);
                syntheticCore = SyntheticSolrCore.createAndRegisterCore(coreContainer, syntheticCoreName, coll.getConfigName());
                syntheticCore.open();
            }
            factory.collectionVsCoreNameMapping.put(collectionName, syntheticCore.getName());
            coreContainer.getZkController().getZkStateReader().registerDocCollectionWatcher(collectionName, collection -> {
                if (collection == null) {
                    factory.collectionVsCoreNameMapping.remove(collectionName);
                    return true;
                }
                return false;
            });
            // ** MonitorExit[var10_10] (shouldn't be in output)
            CoordinatorHttpSolrCall.setMdcLoggingContext(collectionName);
            if (log.isDebugEnabled()) {
                log.debug("coordinator node, returns synthetic core: {}", (Object)syntheticCore.getName());
            }
            return syntheticCore;
        }
    }

    public static String getSyntheticCollectionNameFromConfig(String configName) {
        return SYNTHETIC_COLL_PREFIX + configName;
    }

    public static String getSyntheticCoreNameFromConfig(String configName) {
        return CoordinatorHttpSolrCall.getSyntheticCollectionNameFromConfig(configName) + "_core";
    }

    @Override
    protected void init() throws Exception {
        super.init();
        if (this.action == SolrDispatchFilter.Action.PROCESS && this.core != null) {
            this.solrReq = CoordinatorHttpSolrCall.wrappedReq(this.solrReq, this.collectionName, this);
        }
    }

    @Override
    protected String getCoreOrColName() {
        return this.collectionName;
    }

    public static SolrQueryRequest wrappedReq(SolrQueryRequest delegate, String collectionName, final HttpSolrCall httpSolrCall) {
        Properties p = new Properties();
        if (collectionName != null) {
            p.put("collection", collectionName);
        }
        p.put("replicaType", Replica.Type.PULL.toString());
        p.put("shard", "_");
        final CloudDescriptor cloudDescriptor = new CloudDescriptor(delegate.getCore().getCoreDescriptor(), delegate.getCore().getName(), p);
        return new DelegatingSolrQueryRequest(delegate){

            @Override
            public HttpSolrCall getHttpSolrCall() {
                return httpSolrCall;
            }

            @Override
            public CloudDescriptor getCloudDescriptor() {
                return cloudDescriptor;
            }
        };
    }

    private static void setMdcLoggingContext(String collectionName) {
        MDCLoggingContext.setCollection(collectionName);
        MDCLoggingContext.setCoreName(null);
        MDCLoggingContext.setShard(null);
        MDCLoggingContext.setCoreName(null);
    }

    public static class Factory
    implements SolrDispatchFilter.HttpSolrCallFactory {
        private final Map<String, String> collectionVsCoreNameMapping = new ConcurrentHashMap<String, String>();

        @Override
        public HttpSolrCall createInstance(SolrDispatchFilter filter, String path, CoreContainer cores, HttpServletRequest request, HttpServletResponse response, boolean retry) {
            if (path.startsWith("/____v2/") || path.equals("/____v2")) {
                return new CoordinatorV2HttpSolrCall(this, filter, cores, request, response, retry);
            }
            if (path.startsWith("/.sys.COORDINATOR-COLL-")) {
                return SolrDispatchFilter.HttpSolrCallFactory.super.createInstance(filter, path, cores, request, response, retry);
            }
            return new CoordinatorHttpSolrCall(this, filter, cores, request, response, retry);
        }
    }
}

