/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.api.endpoint.CreateAliasApi;
import org.apache.solr.client.api.model.CategoryRoutedAliasProperties;
import org.apache.solr.client.api.model.CreateAliasRequestBody;
import org.apache.solr.client.api.model.CreateCollectionRequestBody;
import org.apache.solr.client.api.model.RoutedAliasProperties;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.api.model.TimeRoutedAliasProperties;
import org.apache.solr.client.solrj.RoutedAliasTypes;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.cloud.api.collections.TimeRoutedAlias;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.CollectionUtil;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.handler.admin.api.AdminAPIBase;
import org.apache.solr.handler.admin.api.CreateCollection;
import org.apache.solr.jersey.PermissionName;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.TimeZoneUtils;

public class CreateAlias
extends AdminAPIBase
implements CreateAliasApi {
    @Inject
    public CreateAlias(CoreContainer coreContainer, SolrQueryRequest solrQueryRequest, SolrQueryResponse solrQueryResponse) {
        super(coreContainer, solrQueryRequest, solrQueryResponse);
    }

    @PermissionName(value=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public SolrJerseyResponse createAlias(CreateAliasRequestBody requestBody) throws Exception {
        ZkNodeProps remoteMessage;
        SubResponseAccumulatingJerseyResponse response = this.instantiateJerseyResponse(SubResponseAccumulatingJerseyResponse.class);
        CreateAlias.recordCollectionForLogAndTracing(null, this.solrQueryRequest);
        if (requestBody == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Request body is required but missing");
        }
        CreateAlias.validateRequestBody(requestBody);
        if (CollectionUtil.isNotEmpty((Collection)requestBody.collections)) {
            remoteMessage = CreateAlias.createRemoteMessageForTraditionalAlias(requestBody);
        } else {
            assert (CollectionUtil.isNotEmpty((Collection)requestBody.routers));
            Aliases aliases = this.coreContainer.getAliases();
            if (aliases.hasAlias(requestBody.name) && !aliases.isRoutedAlias(requestBody.name)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot add routing parameters to existing non-routed Alias: " + requestBody.name);
            }
            remoteMessage = CreateAlias.createRemoteMessageForRoutedAlias(requestBody);
        }
        SolrResponse remoteResponse = CollectionsHandler.submitCollectionApiCommand(this.coreContainer, this.coreContainer.getDistributedCollectionCommandRunner(), remoteMessage, CollectionParams.CollectionAction.CREATEALIAS, CollectionsHandler.DEFAULT_COLLECTION_OP_TIMEOUT);
        if (remoteResponse.getException() != null) {
            throw remoteResponse.getException();
        }
        if (requestBody.async != null) {
            response.requestId = requestBody.async;
        }
        return response;
    }

    public static ZkNodeProps createRemoteMessageForTraditionalAlias(CreateAliasRequestBody requestBody) {
        HashMap<String, String> remoteMessage = new HashMap<String, String>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.CREATEALIAS.toLower());
        remoteMessage.put("name", requestBody.name);
        remoteMessage.put("collections", String.join((CharSequence)",", requestBody.collections));
        remoteMessage.put("async", requestBody.async);
        return new ZkNodeProps(remoteMessage);
    }

    public static ZkNodeProps createRemoteMessageForRoutedAlias(CreateAliasRequestBody requestBody) {
        HashMap<String, Object> remoteMessage = new HashMap<String, Object>();
        remoteMessage.put("operation", CollectionParams.CollectionAction.CREATEALIAS.toLower());
        remoteMessage.put("name", requestBody.name);
        if (StrUtils.isNotBlank((String)requestBody.async)) {
            remoteMessage.put("async", requestBody.async);
        }
        if (requestBody.routers.size() > 1) {
            for (int i = 0; i < requestBody.routers.size(); ++i) {
                CreateAlias.createValidationHelper((RoutedAliasProperties)requestBody.routers.get(i)).addRemoteMessageProperties(remoteMessage, "router." + i + ".");
            }
        } else if (requestBody.routers.size() == 1) {
            CreateAlias.createValidationHelper((RoutedAliasProperties)requestBody.routers.get(0)).addRemoteMessageProperties(remoteMessage, "router.");
        }
        if (requestBody.collCreationParameters != null) {
            CreateCollection.addToRemoteMessageWithPrefix(requestBody.collCreationParameters, remoteMessage, "create-collection.");
        }
        return new ZkNodeProps(remoteMessage);
    }

    public static CreateAliasRequestBody createFromSolrParams(SolrParams params) {
        CreateAliasRequestBody createBody = new CreateAliasRequestBody();
        createBody.name = params.required().get("name");
        String collections = params.get("collections");
        createBody.collections = StrUtils.isNullOrEmpty((String)collections) ? new ArrayList() : StrUtils.split((String)collections, (char)',');
        createBody.async = params.get("async");
        String typeStr = params.get("router.name");
        if (typeStr == null) {
            return createBody;
        }
        createBody.routers = new ArrayList();
        if (typeStr.startsWith("Dimensional[")) {
            String commaSeparatedDimensions = typeStr.substring("Dimensional[".length(), typeStr.length() - 1);
            String[] dimensions = commaSeparatedDimensions.split(",");
            if (dimensions.length > 2) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "More than 2 dimensions is not supported yet. Please monitor SOLR-13628 for progress");
            }
            for (int i = 0; i < dimensions.length; ++i) {
                createBody.routers.add(CreateAlias.createFromSolrParams(dimensions[i], params, "router." + i + "."));
            }
        } else {
            createBody.routers.add(CreateAlias.createFromSolrParams(typeStr, params, "router."));
        }
        SolrParams createCollectionParams = CreateAlias.getHierarchicalParametersByPrefix(params, "create-collection.");
        createBody.collCreationParameters = CreateCollection.createRequestBodyFromV1Params(createCollectionParams, false);
        return createBody;
    }

    public static RoutedAliasProperties createFromSolrParams(String type, SolrParams params, String propertyPrefix) {
        String typeLower = type.toLowerCase(Locale.ROOT);
        if (typeLower.startsWith("time")) {
            return TimeRoutedAliasValidationHelper.createFromSolrParams(params, propertyPrefix);
        }
        if (typeLower.startsWith("category")) {
            return CategoryRoutedAliasValidationHelper.createFromSolrParams(params, propertyPrefix);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Router name: " + type + " is not in supported types, " + String.valueOf(Arrays.asList(RoutedAliasTypes.values())));
    }

    public static void validateRequestBody(CreateAliasRequestBody requestBody) {
        SolrIdentifierValidator.validateAliasName((String)requestBody.name);
        if (CollectionUtil.isEmpty((Collection)requestBody.collections) && CollectionUtil.isEmpty((Collection)requestBody.routers)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Alias creation requires either a list of either collections (for creating a traditional alias) or routers (for creating a routed alias)");
        }
        if (CollectionUtil.isNotEmpty((Collection)requestBody.routers)) {
            requestBody.routers.forEach(r -> CreateAlias.createValidationHelper(r).validate());
            if (CollectionUtil.isNotEmpty((Collection)requestBody.collections)) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Collections cannot be specified when creating a routed alias.");
            }
            CreateCollectionRequestBody createCollReqBody = requestBody.collCreationParameters;
            if (createCollReqBody != null) {
                if (createCollReqBody.name != null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "routed aliases calculate names for their dependent collections, you cannot specify the name.");
                }
                if (createCollReqBody.config == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Routed alias creation requires a configset name to use for any collections created by the alias.");
                }
            }
        }
    }

    private static RoutedAliasValidationHelper createValidationHelper(RoutedAliasProperties routedAliasProperties) {
        if (routedAliasProperties instanceof TimeRoutedAliasProperties) {
            return new TimeRoutedAliasValidationHelper((TimeRoutedAliasProperties)routedAliasProperties);
        }
        if (routedAliasProperties instanceof CategoryRoutedAliasProperties) {
            return new CategoryRoutedAliasValidationHelper((CategoryRoutedAliasProperties)routedAliasProperties);
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unrecognized routed-alias type provided: " + String.valueOf(routedAliasProperties));
    }

    public static SolrParams getHierarchicalParametersByPrefix(SolrParams paramSource, String prefix) {
        ModifiableSolrParams filteredParams = new ModifiableSolrParams();
        paramSource.stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).forEach(e -> filteredParams.add(((String)e.getKey()).substring(prefix.length()), (String[])e.getValue()));
        return filteredParams;
    }

    public static class CategoryRoutedAliasValidationHelper
    implements RoutedAliasValidationHelper {
        private final CategoryRoutedAliasProperties aliasProperties;

        public CategoryRoutedAliasValidationHelper(CategoryRoutedAliasProperties aliasProperties) {
            this.aliasProperties = aliasProperties;
        }

        @Override
        public void validate() {
            this.ensureRequiredFieldPresent(this.aliasProperties.field, "'field' on category routed alias");
        }

        @Override
        public void addRemoteMessageProperties(Map<String, Object> remoteMessage, String prefix) {
            remoteMessage.put(prefix + "name", "category");
            remoteMessage.put(prefix + "field", this.aliasProperties.field);
            if (this.aliasProperties.maxCardinality != null) {
                remoteMessage.put(prefix + "maxCardinality", this.aliasProperties.maxCardinality);
            }
            if (StrUtils.isNotBlank((String)this.aliasProperties.mustMatch)) {
                remoteMessage.put(prefix + "mustMatch", this.aliasProperties.mustMatch);
            }
        }

        public static CategoryRoutedAliasProperties createFromSolrParams(SolrParams params, String propertyPrefix) {
            CategoryRoutedAliasProperties categoryRoutedProperties = new CategoryRoutedAliasProperties();
            categoryRoutedProperties.field = params.required().get(propertyPrefix + "field");
            categoryRoutedProperties.maxCardinality = params.getLong(propertyPrefix + "maxCardinality");
            categoryRoutedProperties.mustMatch = params.get(propertyPrefix + "mustMatch");
            return categoryRoutedProperties;
        }
    }

    public static class TimeRoutedAliasValidationHelper
    implements RoutedAliasValidationHelper {
        private final TimeRoutedAliasProperties aliasProperties;

        public TimeRoutedAliasValidationHelper(TimeRoutedAliasProperties aliasProperties) {
            this.aliasProperties = aliasProperties;
        }

        @Override
        public void validate() {
            this.ensureRequiredFieldPresent(this.aliasProperties.field, "'field' on time routed alias");
            this.ensureRequiredFieldPresent(this.aliasProperties.start, "'start' on time routed alias");
            this.ensureRequiredFieldPresent(this.aliasProperties.interval, "'interval' on time routed alias");
            TimeRoutedAlias.parseStringAsInstant(this.aliasProperties.start, TimeZoneUtils.parseTimezone(this.aliasProperties.tz));
            if (this.aliasProperties.maxFutureMs != null && this.aliasProperties.maxFutureMs < 0L) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "router.maxFutureMs must be >= 0");
            }
        }

        @Override
        public void addRemoteMessageProperties(Map<String, Object> remoteMessage, String prefix) {
            remoteMessage.put(prefix + "name", "time");
            remoteMessage.put(prefix + "field", this.aliasProperties.field);
            remoteMessage.put(prefix + "start", this.aliasProperties.start);
            remoteMessage.put(prefix + "interval", this.aliasProperties.interval);
            if (this.aliasProperties.tz != null) {
                remoteMessage.put(prefix + "tz", this.aliasProperties.tz);
            }
            if (this.aliasProperties.maxFutureMs != null) {
                remoteMessage.put(prefix + "maxFutureMs", this.aliasProperties.maxFutureMs);
            }
            if (this.aliasProperties.preemptiveCreateMath != null) {
                remoteMessage.put(prefix + "preemptiveCreateMath", this.aliasProperties.preemptiveCreateMath);
            }
            if (this.aliasProperties.autoDeleteAge != null) {
                remoteMessage.put(prefix + "autoDeleteAge", this.aliasProperties.autoDeleteAge);
            }
        }

        public static TimeRoutedAliasProperties createFromSolrParams(SolrParams params, String propertyPrefix) {
            TimeRoutedAliasProperties timeRoutedProperties = new TimeRoutedAliasProperties();
            timeRoutedProperties.field = params.required().get(propertyPrefix + "field");
            timeRoutedProperties.start = params.required().get(propertyPrefix + "start");
            timeRoutedProperties.interval = params.required().get(propertyPrefix + "interval");
            timeRoutedProperties.tz = params.get(propertyPrefix + "tz");
            timeRoutedProperties.maxFutureMs = params.getLong(propertyPrefix + "maxFutureMs");
            timeRoutedProperties.preemptiveCreateMath = params.get(propertyPrefix + "preemptiveCreateMath");
            timeRoutedProperties.autoDeleteAge = params.get(propertyPrefix + "autoDeleteAge");
            return timeRoutedProperties;
        }
    }

    private static interface RoutedAliasValidationHelper {
        public void validate();

        public void addRemoteMessageProperties(Map<String, Object> var1, String var2);

        default public void ensureRequiredFieldPresent(Object val, String name) {
            if (val == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: " + name);
            }
        }
    }
}

