/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetryOOB;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TelemetryThreadPool {
    private static final int CORE_POOL_SIZE = 10;
    private final ExecutorService uploader;
    private static TelemetryThreadPool instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TelemetryThreadPool getInstance() {
        if (instance != null) return instance;
        Class<TelemetryThreadPool> clazz = TelemetryThreadPool.class;
        synchronized (TelemetryThreadPool.class) {
            if (instance != null) return instance;
            instance = new TelemetryThreadPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TelemetryThreadPool() {
        ThreadFactory daemonThreadFactory = r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("telemetry-uploader-" + thread.getId());
            thread.setDaemon(true);
            return thread;
        };
        this.uploader = new ThreadPoolExecutor(10, 10, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), daemonThreadFactory);
        ((ThreadPoolExecutor)this.uploader).allowCoreThreadTimeOut(true);
    }

    public void execute(Runnable task) {
        this.uploader.execute(task);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.uploader.submit(task);
    }
}

