/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.snowflake.common.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FunctionPointer {
    Method function;
    int argCount;

    public FunctionPointer(String functionName, int argCount) throws ClassNotFoundException, NoSuchMethodException {
        String[] methodStr = functionName.split("\\:", 2);
        this.argCount = argCount;
        this.findMethod(methodStr[0], methodStr[1]);
    }

    public FunctionPointer(String className, String function, int argCount) throws ClassNotFoundException, NoSuchMethodException {
        this.argCount = argCount;
        this.findMethod(className, function);
    }

    private void findMethod(String className, String function) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        Class<?> klass = Class.forName(className);
        switch (this.argCount) {
            case 0: {
                this.function = klass.getMethod(function, new Class[0]);
                break;
            }
            case 1: {
                this.function = klass.getMethod(function, Object.class);
                break;
            }
            case 2: {
                this.function = klass.getMethod(function, Object.class, Object.class);
                break;
            }
            case 3: {
                this.function = klass.getMethod(function, Object.class, Object.class, Object.class);
                break;
            }
            case 4: {
                this.function = klass.getMethod(function, Object.class, Object.class, Object.class, Object.class);
                break;
            }
            case 5: {
                this.function = klass.getMethod(function, Object.class, Object.class, Object.class, Object.class, Object.class);
                break;
            }
            case 6: {
                this.function = klass.getMethod(function, Object.class, Object.class, Object.class, Object.class, Object.class, Object.class);
                break;
            }
            default: {
                throw new NoSuchMethodException("Add support for funciton pointers tomethods with more than 6 parameters");
            }
        }
    }

    public Object invoke(Object ... args) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException {
        if (args.length != this.argCount) {
            throw new IllegalArgumentException("Incorrect number of arguments. Function " + this.function.toString() + ", expects " + this.argCount + " arguments.");
        }
        return this.function.invoke(null, args);
    }
}

