/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.ScopeConfigurator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.SdkMeterProvider;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.ViewBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.export.MetricReader;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.MeterConfig;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.export.CardinalityLimitSelector;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view.StringPredicates;

public final class SdkMeterProviderUtil {
    private SdkMeterProviderUtil() {
    }

    public static void setExemplarFilter(SdkMeterProviderBuilder sdkMeterProviderBuilder, ExemplarFilter exemplarFilter) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("setExemplarFilter", ExemplarFilter.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, exemplarFilter);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setExemplarFilter on SdkMeterProviderBuilder", e);
        }
    }

    public static void registerMetricReaderWithCardinalitySelector(SdkMeterProviderBuilder sdkMeterProviderBuilder, MetricReader metricReader, CardinalityLimitSelector cardinalityLimitSelector) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("registerMetricReader", MetricReader.class, CardinalityLimitSelector.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, metricReader, cardinalityLimitSelector);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling addMetricReader on SdkMeterProviderBuilder", e);
        }
    }

    public static void setMeterConfigurator(SdkMeterProviderBuilder sdkMeterProviderBuilder, ScopeConfigurator<MeterConfig> meterConfigurator) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("setMeterConfigurator", ScopeConfigurator.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, meterConfigurator);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling setMeterConfigurator on SdkMeterProviderBuilder", e);
        }
    }

    public static void addMeterConfiguratorCondition(SdkMeterProviderBuilder sdkMeterProviderBuilder, Predicate<InstrumentationScopeInfo> scopeMatcher, MeterConfig meterConfig) {
        try {
            Method method = SdkMeterProviderBuilder.class.getDeclaredMethod("addMeterConfiguratorCondition", Predicate.class, MeterConfig.class);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProviderBuilder, scopeMatcher, meterConfig);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling addMeterConfiguratorCondition on SdkMeterProviderBuilder", e);
        }
    }

    public static void appendFilteredBaggageAttributes(ViewBuilder viewBuilder, Predicate<String> keyFilter) {
        SdkMeterProviderUtil.addAttributesProcessor(viewBuilder, AttributesProcessor.appendBaggageByKeyName(keyFilter));
    }

    public static void appendAllBaggageAttributes(ViewBuilder viewBuilder) {
        SdkMeterProviderUtil.appendFilteredBaggageAttributes(viewBuilder, StringPredicates.ALL);
    }

    private static void addAttributesProcessor(ViewBuilder viewBuilder, AttributesProcessor attributesProcessor) {
        try {
            Method method = ViewBuilder.class.getDeclaredMethod("addAttributesProcessor", AttributesProcessor.class);
            method.setAccessible(true);
            method.invoke((Object)viewBuilder, attributesProcessor);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error adding AttributesProcessor to ViewBuilder", e);
        }
    }

    public static void setCardinalityLimit(ViewBuilder viewBuilder, int cardinalityLimit) {
        try {
            Method method = ViewBuilder.class.getDeclaredMethod("setCardinalityLimit", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)viewBuilder, cardinalityLimit);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error setting cardinalityLimit on ViewBuilder", e);
        }
    }

    public static void resetForTest(SdkMeterProvider sdkMeterProvider) {
        try {
            Method method = SdkMeterProvider.class.getDeclaredMethod("resetForTest", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)sdkMeterProvider, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Error calling resetForTest on SdkMeterProvider", e);
        }
    }
}

