/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.api.trace;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.Span;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanContext;
import net.snowflake.client.jdbc.internal.opentelemetry.api.trace.SpanKind;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;

public interface SpanBuilder {
    public SpanBuilder setParent(Context var1);

    public SpanBuilder setNoParent();

    public SpanBuilder addLink(SpanContext var1);

    public SpanBuilder addLink(SpanContext var1, Attributes var2);

    public SpanBuilder setAttribute(String var1, String var2);

    public SpanBuilder setAttribute(String var1, long var2);

    public SpanBuilder setAttribute(String var1, double var2);

    public SpanBuilder setAttribute(String var1, boolean var2);

    public <T> SpanBuilder setAttribute(AttributeKey<T> var1, T var2);

    default public SpanBuilder setAllAttributes(Attributes attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return this;
        }
        attributes.forEach((attributeKey, value) -> this.setAttribute((AttributeKey)attributeKey, (Object)value));
        return this;
    }

    public SpanBuilder setSpanKind(SpanKind var1);

    public SpanBuilder setStartTimestamp(long var1, TimeUnit var3);

    default public SpanBuilder setStartTimestamp(Instant startTimestamp) {
        if (startTimestamp == null) {
            return this;
        }
        return this.setStartTimestamp(TimeUnit.SECONDS.toNanos(startTimestamp.getEpochSecond()) + (long)startTimestamp.getNano(), TimeUnit.NANOSECONDS);
    }

    public Span startSpan();
}

