/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opencensus.trace.propagation;

import java.text.ParseException;
import net.snowflake.client.jdbc.internal.opencensus.internal.Utils;
import net.snowflake.client.jdbc.internal.opencensus.trace.SpanContext;
import net.snowflake.client.jdbc.internal.opencensus.trace.propagation.SpanContextParseException;

public abstract class BinaryFormat {
    static final NoopBinaryFormat NOOP_BINARY_FORMAT = new NoopBinaryFormat();

    @Deprecated
    public byte[] toBinaryValue(SpanContext spanContext) {
        return this.toByteArray(spanContext);
    }

    public byte[] toByteArray(SpanContext spanContext) {
        return this.toBinaryValue(spanContext);
    }

    @Deprecated
    public SpanContext fromBinaryValue(byte[] bytes) throws ParseException {
        try {
            return this.fromByteArray(bytes);
        }
        catch (SpanContextParseException e) {
            throw new ParseException(e.toString(), 0);
        }
    }

    public SpanContext fromByteArray(byte[] bytes) throws SpanContextParseException {
        try {
            return this.fromBinaryValue(bytes);
        }
        catch (ParseException e) {
            throw new SpanContextParseException("Error while parsing.", e);
        }
    }

    static BinaryFormat getNoopBinaryFormat() {
        return NOOP_BINARY_FORMAT;
    }

    private static final class NoopBinaryFormat
    extends BinaryFormat {
        @Override
        public byte[] toByteArray(SpanContext spanContext) {
            Utils.checkNotNull(spanContext, "spanContext");
            return new byte[0];
        }

        @Override
        public SpanContext fromByteArray(byte[] bytes) {
            Utils.checkNotNull(bytes, "bytes");
            return SpanContext.INVALID;
        }

        private NoopBinaryFormat() {
        }
    }
}

