/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.inprocess;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.InternalChannelz;
import net.snowflake.client.jdbc.internal.grpc.InternalInstrumented;
import net.snowflake.client.jdbc.internal.grpc.ServerStreamTracer;
import net.snowflake.client.jdbc.internal.grpc.inprocess.AnonymousInProcessSocketAddress;
import net.snowflake.client.jdbc.internal.grpc.inprocess.InProcessServerBuilder;
import net.snowflake.client.jdbc.internal.grpc.inprocess.InProcessSocketAddress;
import net.snowflake.client.jdbc.internal.grpc.inprocess.InProcessTransport;
import net.snowflake.client.jdbc.internal.grpc.internal.InternalServer;
import net.snowflake.client.jdbc.internal.grpc.internal.ObjectPool;
import net.snowflake.client.jdbc.internal.grpc.internal.ServerListener;
import net.snowflake.client.jdbc.internal.grpc.internal.ServerTransportListener;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class InProcessServer
implements InternalServer {
    private static final ConcurrentMap<String, InProcessServer> registry = new ConcurrentHashMap<String, InProcessServer>();
    private final SocketAddress listenAddress;
    private final int maxInboundMetadataSize;
    private final List<ServerStreamTracer.Factory> streamTracerFactories;
    private ServerListener listener;
    private boolean shutdown;
    private final ObjectPool<ScheduledExecutorService> schedulerPool;
    private ScheduledExecutorService scheduler;

    static InProcessServer findServer(SocketAddress addr) {
        if (addr instanceof AnonymousInProcessSocketAddress) {
            return ((AnonymousInProcessSocketAddress)addr).getServer();
        }
        if (addr instanceof InProcessSocketAddress) {
            return (InProcessServer)registry.get(((InProcessSocketAddress)addr).getName());
        }
        return null;
    }

    InProcessServer(InProcessServerBuilder builder, List<? extends ServerStreamTracer.Factory> streamTracerFactories) {
        this.listenAddress = builder.listenAddress;
        this.schedulerPool = builder.schedulerPool;
        this.maxInboundMetadataSize = builder.maxInboundMetadataSize;
        this.streamTracerFactories = Collections.unmodifiableList(Preconditions.checkNotNull(streamTracerFactories, "streamTracerFactories"));
    }

    @Override
    public void start(ServerListener serverListener) throws IOException {
        this.listener = serverListener;
        this.scheduler = this.schedulerPool.getObject();
        this.registerInstance();
    }

    private void registerInstance() throws IOException {
        if (this.listenAddress instanceof AnonymousInProcessSocketAddress) {
            ((AnonymousInProcessSocketAddress)this.listenAddress).setServer(this);
        } else if (this.listenAddress instanceof InProcessSocketAddress) {
            String name = ((InProcessSocketAddress)this.listenAddress).getName();
            if (registry.putIfAbsent(name, this) != null) {
                throw new IOException("name already registered: " + name);
            }
        } else {
            throw new AssertionError();
        }
    }

    @Override
    public SocketAddress getListenSocketAddress() {
        return this.listenAddress;
    }

    @Override
    public List<? extends SocketAddress> getListenSocketAddresses() {
        return Collections.singletonList(this.getListenSocketAddress());
    }

    @Override
    public InternalInstrumented<InternalChannelz.SocketStats> getListenSocketStats() {
        return null;
    }

    @Override
    public List<InternalInstrumented<InternalChannelz.SocketStats>> getListenSocketStatsList() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.unregisterInstance();
        this.scheduler = this.schedulerPool.returnObject(this.scheduler);
        InProcessServer inProcessServer = this;
        synchronized (inProcessServer) {
            this.shutdown = true;
            this.listener.serverShutdown();
        }
    }

    private void unregisterInstance() {
        if (this.listenAddress instanceof AnonymousInProcessSocketAddress) {
            ((AnonymousInProcessSocketAddress)this.listenAddress).clearServer(this);
        } else if (this.listenAddress instanceof InProcessSocketAddress) {
            String name = ((InProcessSocketAddress)this.listenAddress).getName();
            if (!registry.remove(name, this)) {
                throw new AssertionError();
            }
        } else {
            throw new AssertionError();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("listenAddress", this.listenAddress).toString();
    }

    synchronized ServerTransportListener register(InProcessTransport transport) {
        if (this.shutdown) {
            return null;
        }
        return this.listener.transportCreated(transport);
    }

    ObjectPool<ScheduledExecutorService> getScheduledExecutorServicePool() {
        return this.schedulerPool;
    }

    int getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    List<ServerStreamTracer.Factory> getStreamTracerFactories() {
        return this.streamTracerFactories;
    }
}

