/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.util.List;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcStatusCode;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiException;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ErrorDetails;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.StatusCode;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobId;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.grpc.Status;

public final class ParallelCompositeUploadException
extends ApiException {
    private final ApiFuture<List<BlobId>> createdObjects;

    private ParallelCompositeUploadException(Throwable cause, StatusCode statusCode, ErrorDetails errorDetails, ApiFuture<List<BlobId>> createdObjects) {
        super(cause, statusCode, false, errorDetails);
        this.createdObjects = createdObjects;
    }

    public ApiFuture<List<BlobId>> getCreatedObjects() {
        return this.createdObjects;
    }

    static ParallelCompositeUploadException of(Throwable t2, ApiFuture<List<BlobId>> createdObjects) {
        ErrorDetails errorDetails;
        StatusCode statusCode;
        Throwable cause = t2;
        if (t2 instanceof StorageException && t2.getCause() != null) {
            cause = t2.getCause();
        }
        if (cause instanceof ApiException) {
            ApiException apiException = (ApiException)cause;
            statusCode = apiException.getStatusCode();
            errorDetails = apiException.getErrorDetails();
        } else {
            statusCode = GrpcStatusCode.of(Status.Code.UNKNOWN);
            errorDetails = ErrorDetails.builder().build();
        }
        return new ParallelCompositeUploadException(cause, statusCode, errorDetails, createdObjects);
    }
}

