/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.math.BigDecimal;
import java.math.MathContext;
import java.net.NoRouteToHostException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFunction;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.PermissionDeniedException;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnavailableException;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.GoogleCloudMetricExporter;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.MetricConfiguration;
import net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.metric.MonitoredResourceDescription;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableSet;
import net.snowflake.client.jdbc.internal.google.common.collect.Iterables;
import net.snowflake.client.jdbc.internal.grpc.ManagedChannelBuilder;
import net.snowflake.client.jdbc.internal.grpc.opentelemetry.GrpcOpenTelemetry;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.internal.StringUtils;
import net.snowflake.client.jdbc.internal.opentelemetry.contrib.gcp.resource.GCPResourceProvider;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.OpenTelemetrySdk;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.CompletableResultCode;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.export.MemoryMode;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.Aggregation;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentSelector;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.SdkMeterProvider;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.View;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.AggregationTemporality;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.MetricData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.export.MetricExporter;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.resources.Resource;

final class OpenTelemetryBootstrappingUtils {
    private static final Collection<String> METRICS_TO_ENABLE = ImmutableList.of("net.snowflake.client.jdbc.internal.grpc.lb.wrr.rr_fallback", "net.snowflake.client.jdbc.internal.grpc.lb.wrr.endpoint_weight_not_yet_usable", "net.snowflake.client.jdbc.internal.grpc.lb.wrr.endpoint_weight_stale", "net.snowflake.client.jdbc.internal.grpc.lb.wrr.endpoint_weights", "net.snowflake.client.jdbc.internal.grpc.lb.rls.cache_entries", "net.snowflake.client.jdbc.internal.grpc.lb.rls.cache_size", "net.snowflake.client.jdbc.internal.grpc.lb.rls.default_target_picks", "net.snowflake.client.jdbc.internal.grpc.lb.rls.target_picks", "net.snowflake.client.jdbc.internal.grpc.lb.rls.failed_picks", "net.snowflake.client.jdbc.internal.grpc.xds_client.connected", "net.snowflake.client.jdbc.internal.grpc.xds_client.server_failure", "net.snowflake.client.jdbc.internal.grpc.xds_client.resource_updates_valid", new String[]{"net.snowflake.client.jdbc.internal.grpc.xds_client.resource_updates_invalid", "net.snowflake.client.jdbc.internal.grpc.xds_client.resources"});
    private static final Collection<String> METRICS_ENABLED_BY_DEFAULT = ImmutableList.of("net.snowflake.client.jdbc.internal.grpc.client.attempt.sent_total_compressed_message_size", "net.snowflake.client.jdbc.internal.grpc.client.attempt.rcvd_total_compressed_message_size", "net.snowflake.client.jdbc.internal.grpc.client.attempt.started", "net.snowflake.client.jdbc.internal.grpc.client.attempt.duration", "net.snowflake.client.jdbc.internal.grpc.client.call.duration");
    static final Logger log = Logger.getLogger(OpenTelemetryBootstrappingUtils.class.getName());

    OpenTelemetryBootstrappingUtils() {
    }

    static void enableGrpcMetrics(InstantiatingGrpcChannelProvider.Builder channelProviderBuilder, String endpoint, String projectId, String universeDomain, boolean shouldSuppressExceptions) {
        String metricServiceEndpoint = OpenTelemetryBootstrappingUtils.getCloudMonitoringEndpoint(endpoint, universeDomain);
        SdkMeterProvider provider = OpenTelemetryBootstrappingUtils.createMeterProvider(metricServiceEndpoint, projectId, shouldSuppressExceptions);
        OpenTelemetrySdk openTelemetrySdk = OpenTelemetrySdk.builder().setMeterProvider(provider).build();
        GrpcOpenTelemetry grpcOpenTelemetry = GrpcOpenTelemetry.newBuilder().sdk(openTelemetrySdk).addOptionalLabel("net.snowflake.client.jdbc.internal.grpc.lb.locality").enableMetrics(METRICS_TO_ENABLE).build();
        ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> channelConfigurator = channelProviderBuilder.getChannelConfigurator();
        channelProviderBuilder.setChannelConfigurator(b -> {
            grpcOpenTelemetry.configureChannelBuilder((ManagedChannelBuilder<?>)b);
            if (channelConfigurator != null) {
                return (ManagedChannelBuilder)channelConfigurator.apply((ManagedChannelBuilder)b);
            }
            return b;
        });
    }

    @VisibleForTesting
    static String getCloudMonitoringEndpoint(String endpoint, String universeDomain) {
        String metricServiceEndpoint = "monitoring.googleapis.com";
        if (universeDomain != null && endpoint.contains("storage." + universeDomain)) {
            metricServiceEndpoint = "monitoring." + universeDomain;
        } else if (!endpoint.contains("storage.googleapis.com")) {
            String match;
            String canonicalEndpoint = "storage.googleapis.com";
            String privateEndpoint = "private.googleapis.com";
            String restrictedEndpoint = "restricted.googleapis.com";
            if (universeDomain != null) {
                canonicalEndpoint = "storage." + universeDomain;
                privateEndpoint = "private." + universeDomain;
                restrictedEndpoint = "restricted." + universeDomain;
            }
            if (!StringUtils.isNullOrEmpty(match = ImmutableList.of(canonicalEndpoint, privateEndpoint, restrictedEndpoint).stream().filter(s2 -> endpoint.contains((CharSequence)s2) || endpoint.contains("google-c2p:///" + s2)).collect(Collectors.joining()))) {
                metricServiceEndpoint = match;
            }
        }
        return metricServiceEndpoint + ":" + endpoint.split(":")[1];
    }

    @VisibleForTesting
    static SdkMeterProvider createMeterProvider(String metricServiceEndpoint, String projectId, boolean shouldSuppressExceptions) {
        String projectIdToUse;
        GCPResourceProvider resourceProvider = new GCPResourceProvider();
        Attributes detectedAttributes = resourceProvider.getAttributes();
        String detectedProjectId = detectedAttributes.get(AttributeKey.stringKey("cloud.account.id"));
        String string = projectIdToUse = detectedProjectId == null ? projectId : detectedProjectId;
        if (!projectIdToUse.equals(projectId)) {
            log.warning("The Project ID configured for metrics is " + projectIdToUse + ", but the Project ID of the storage client is " + projectId + ". Make sure that the service account in use has the required metric writing role (roles/monitoring.metricWriter) in the project " + projectIdToUse + ", or metrics will not be written.");
        }
        MonitoredResourceDescription monitoredResourceDescription = new MonitoredResourceDescription("storage.googleapis.com/Client", ImmutableSet.of("project_id", "location", "cloud_platform", "host_id", "instance_id", "api", new String[0]));
        MetricExporter cloudMonitoringExporter = GoogleCloudMetricExporter.createWithConfiguration(MetricConfiguration.builder().setMonitoredResourceDescription(monitoredResourceDescription).setInstrumentationLibraryLabelsEnabled(false).setMetricServiceEndpoint(metricServiceEndpoint).setPrefix("storage.googleapis.com/client").setUseServiceTimeSeries(true).setProjectId(projectIdToUse).build());
        SdkMeterProviderBuilder providerBuilder = SdkMeterProvider.builder();
        for (String metric : ImmutableList.copyOf(Iterables.concat(METRICS_TO_ENABLE, METRICS_ENABLED_BY_DEFAULT))) {
            providerBuilder.registerView(InstrumentSelector.builder().setName(metric).build(), View.builder().setName(metric.replace(".", "/")).build());
        }
        MetricExporter exporter = shouldSuppressExceptions ? new PermissionDeniedSingleReportMetricsExporter(cloudMonitoringExporter) : cloudMonitoringExporter;
        providerBuilder.registerMetricReader(PeriodicMetricReader.builder(exporter).setInterval(Duration.ofSeconds(60L)).build()).setResource(Resource.create(Attributes.builder().put("gcp.resource_type", "storage.googleapis.com/Client").put("location", detectedAttributes.get(AttributeKey.stringKey("cloud.region"))).put("project_id", projectIdToUse).put("cloud_platform", detectedAttributes.get(AttributeKey.stringKey("cloud.platform"))).put("host_id", detectedAttributes.get(AttributeKey.stringKey("host.id"))).put("instance_id", UUID.randomUUID().toString()).put("api", "net.snowflake.client.jdbc.internal.grpc").build()));
        OpenTelemetryBootstrappingUtils.addHistogramView(providerBuilder, OpenTelemetryBootstrappingUtils.latencyHistogramBoundaries(), "net/snowflake/client/jdbc/internal/grpc/client/attempt/duration", "s");
        OpenTelemetryBootstrappingUtils.addHistogramView(providerBuilder, OpenTelemetryBootstrappingUtils.sizeHistogramBoundaries(), "net/snowflake/client/jdbc/internal/grpc/client/attempt/rcvd_total_compressed_message_size", "By");
        OpenTelemetryBootstrappingUtils.addHistogramView(providerBuilder, OpenTelemetryBootstrappingUtils.sizeHistogramBoundaries(), "net/snowflake/client/jdbc/internal/grpc/client/attempt/sent_total_compressed_message_size", "By");
        return providerBuilder.build();
    }

    private static void addHistogramView(SdkMeterProviderBuilder provider, List<Double> boundaries, String name, String unit) {
        InstrumentSelector instrumentSelector = InstrumentSelector.builder().setType(InstrumentType.HISTOGRAM).setUnit(unit).setName(name).setMeterName("net.snowflake.client.jdbc.internal.grpc-java").setMeterSchemaUrl("").build();
        View view = View.builder().setName(name).setDescription("A view of " + name + " with histogram boundaries more appropriate for Google Cloud Storage RPCs").setAggregation(Aggregation.explicitBucketHistogram(boundaries)).build();
        provider.registerView(instrumentSelector, view);
    }

    private static List<Double> latencyHistogramBoundaries() {
        int i;
        ArrayList<Double> boundaries = new ArrayList<Double>();
        BigDecimal boundary = new BigDecimal(0, MathContext.UNLIMITED);
        BigDecimal increment = new BigDecimal("0.002", MathContext.UNLIMITED);
        for (i = 0; i != 50; ++i) {
            boundaries.add(boundary.doubleValue());
            boundary = boundary.add(increment);
        }
        increment = new BigDecimal("0.01", MathContext.UNLIMITED);
        for (i = 0; i != 150 && boundary.compareTo(new BigDecimal(300)) < 1; ++i) {
            boundaries.add(boundary.doubleValue());
            if (i != 0 && i % 10 == 0) {
                increment = increment.multiply(new BigDecimal(2));
            }
            boundary = boundary.add(increment);
        }
        return boundaries;
    }

    private static List<Double> sizeHistogramBoundaries() {
        long kb = 1024L;
        long mb = 1024L * kb;
        long gb = 1024L * mb;
        ArrayList<Double> boundaries = new ArrayList<Double>();
        long boundary = 0L;
        long increment = 128L * kb;
        while (boundaries.size() < 200 && boundary <= 16L * gb) {
            boundaries.add(Double.valueOf(boundary));
            if ((boundary += increment) < 4L * mb) continue;
            increment *= 2L;
        }
        return boundaries;
    }

    private static final class PermissionDeniedSingleReportMetricsExporter
    implements MetricExporter {
        private final MetricExporter delegate;
        private final AtomicBoolean seenPermissionDenied = new AtomicBoolean(false);
        private final AtomicBoolean seenNoRouteToHost = new AtomicBoolean(false);

        private PermissionDeniedSingleReportMetricsExporter(MetricExporter delegate) {
            this.delegate = delegate;
        }

        @Override
        public CompletableResultCode export(Collection<MetricData> metrics) {
            if (this.seenPermissionDenied.get() && this.seenNoRouteToHost.get()) {
                return CompletableResultCode.ofFailure();
            }
            try {
                return this.delegate.export(metrics);
            }
            catch (PermissionDeniedException e) {
                if (!this.seenPermissionDenied.get()) {
                    this.seenPermissionDenied.set(true);
                    throw e;
                }
                return CompletableResultCode.ofFailure();
            }
            catch (UnavailableException e) {
                if (this.seenPermissionDenied.get() && !this.seenNoRouteToHost.get() && PermissionDeniedSingleReportMetricsExporter.ultimateCause(e, NoRouteToHostException.class)) {
                    this.seenNoRouteToHost.set(true);
                    throw e;
                }
                return CompletableResultCode.ofFailure();
            }
        }

        @Override
        public Aggregation getDefaultAggregation(InstrumentType instrumentType) {
            return this.delegate.getDefaultAggregation(instrumentType);
        }

        @Override
        public MemoryMode getMemoryMode() {
            return this.delegate.getMemoryMode();
        }

        @Override
        public CompletableResultCode flush() {
            return this.delegate.flush();
        }

        @Override
        public CompletableResultCode shutdown() {
            return this.delegate.shutdown();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
            return this.delegate.getAggregationTemporality(instrumentType);
        }

        @Override
        public DefaultAggregationSelector with(InstrumentType instrumentType, Aggregation aggregation) {
            return this.delegate.with(instrumentType, aggregation);
        }

        private static boolean ultimateCause(Throwable t2, Class<? extends Throwable> c) {
            if (t2 == null) {
                return false;
            }
            Throwable cause = t2.getCause();
            if (cause != null && c.isAssignableFrom(cause.getClass())) {
                return true;
            }
            return PermissionDeniedSingleReportMetricsExporter.ultimateCause(cause, c);
        }
    }
}

