/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.ResultRetryAlgorithm;
import net.snowflake.client.jdbc.internal.google.api.services.storage.model.StorageObject;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Conversions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpClientContext;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpContentRange;
import net.snowflake.client.jdbc.internal.google.cloud.storage.JsonResumableSessionPutTask;
import net.snowflake.client.jdbc.internal.google.cloud.storage.JsonResumableSessionQueryTask;
import net.snowflake.client.jdbc.internal.google.cloud.storage.JsonResumableWrite;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ResumableOperationResult;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Retrying;
import net.snowflake.client.jdbc.internal.google.cloud.storage.RewindableContent;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.HttpRpcContext;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.HttpStorageRpc;
import net.snowflake.client.jdbc.internal.opencensus.trace.EndSpanOptions;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.Nullable;

final class JsonResumableSession {
    static final String SPAN_NAME_WRITE = String.format("Sent.%s.write", HttpStorageRpc.class.getName());
    static final EndSpanOptions END_SPAN_OPTIONS = EndSpanOptions.builder().setSampleToLocalSpanStore(true).build();
    private final HttpClientContext context;
    private final Retrying.RetryingDependencies deps;
    private final ResultRetryAlgorithm<?> alg;
    private final JsonResumableWrite resumableWrite;

    JsonResumableSession(HttpClientContext context, Retrying.RetryingDependencies deps, ResultRetryAlgorithm<?> alg, JsonResumableWrite resumableWrite) {
        this.context = context;
        this.deps = deps;
        this.alg = alg;
        this.resumableWrite = resumableWrite;
    }

    ResumableOperationResult<@Nullable StorageObject> query() {
        return new JsonResumableSessionQueryTask(this.context, this.resumableWrite.getUploadId()).call();
    }

    ResumableOperationResult<@Nullable StorageObject> put(RewindableContent content, HttpContentRange contentRange) {
        JsonResumableSessionPutTask task = new JsonResumableSessionPutTask(this.context, this.resumableWrite.getUploadId(), content, contentRange);
        HttpRpcContext httpRpcContext = HttpRpcContext.getInstance();
        httpRpcContext.newInvocationId();
        AtomicBoolean dirty = new AtomicBoolean(false);
        return (ResumableOperationResult)Retrying.run(this.deps, this.alg, () -> {
            if (dirty.getAndSet(true)) {
                ResumableOperationResult<@Nullable StorageObject> query = this.query();
                long persistedSize = query.getPersistedSize();
                if (contentRange.endOffsetEquals(persistedSize) || query.getObject() != null) {
                    return query;
                }
                task.rewindTo(persistedSize);
            }
            return task.call();
        }, Conversions.Decoder.identity());
    }
}

