/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.opentelemetry.shadow.semconv;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;

public final class AttributeKeyTemplate<T> {
    private final String prefix;
    private final Function<String, AttributeKey<T>> keyBuilder;
    private final ConcurrentMap<String, AttributeKey<T>> keysCache = new ConcurrentHashMap<String, AttributeKey<T>>(1);

    private AttributeKeyTemplate(String prefix, Function<String, AttributeKey<T>> keyBuilder) {
        this.prefix = prefix;
        this.keyBuilder = keyBuilder;
    }

    public static AttributeKeyTemplate<String> stringKeyTemplate(String prefix) {
        return new AttributeKeyTemplate<String>(prefix, AttributeKey::stringKey);
    }

    public static AttributeKeyTemplate<List<String>> stringArrayKeyTemplate(String prefix) {
        return new AttributeKeyTemplate<List<String>>(prefix, AttributeKey::stringArrayKey);
    }

    public static AttributeKeyTemplate<Boolean> booleanKeyTemplate(String prefix) {
        return new AttributeKeyTemplate<Boolean>(prefix, AttributeKey::booleanKey);
    }

    public static AttributeKeyTemplate<List<Boolean>> booleanArrayKeyTemplate(String prefix) {
        return new AttributeKeyTemplate<List<Boolean>>(prefix, AttributeKey::booleanArrayKey);
    }

    public static AttributeKeyTemplate<Long> longKeyTemplate(String prefix) {
        return new AttributeKeyTemplate<Long>(prefix, AttributeKey::longKey);
    }

    public static AttributeKeyTemplate<List<Long>> longArrayKeyTemplate(String prefix) {
        return new AttributeKeyTemplate<List<Long>>(prefix, AttributeKey::longArrayKey);
    }

    public static AttributeKeyTemplate<Double> doubleKeyTemplate(String prefix) {
        return new AttributeKeyTemplate<Double>(prefix, AttributeKey::doubleKey);
    }

    public static AttributeKeyTemplate<List<Double>> doubleArrayKeyTemplate(String prefix) {
        return new AttributeKeyTemplate<List<Double>>(prefix, AttributeKey::doubleArrayKey);
    }

    private AttributeKey<T> createAttributeKey(String keyName) {
        String key = this.prefix + "." + keyName;
        return this.keyBuilder.apply(key);
    }

    public AttributeKey<T> getAttributeKey(String key) {
        return this.keysCache.computeIfAbsent(key, this::createAttributeKey);
    }
}

