/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.grpc;

import java.util.Set;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcStatusCode;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiException;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiExceptionFactory;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ErrorDetails;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.StatusCode;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableSet;
import net.snowflake.client.jdbc.internal.google.protobuf.InvalidProtocolBufferException;
import net.snowflake.client.jdbc.internal.google.rpc.Status;
import net.snowflake.client.jdbc.internal.grpc.Metadata;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.StatusException;
import net.snowflake.client.jdbc.internal.grpc.StatusRuntimeException;

class GrpcApiExceptionFactory {
    @VisibleForTesting
    static final String ERROR_DETAIL_KEY = "net.snowflake.client.jdbc.internal.grpc-status-details-bin";
    private final ImmutableSet<StatusCode.Code> retryableCodes;

    GrpcApiExceptionFactory(Set<StatusCode.Code> retryCodes) {
        this.retryableCodes = ImmutableSet.copyOf(retryCodes);
    }

    ApiException create(Throwable throwable) {
        if (throwable instanceof StatusException) {
            StatusException e = (StatusException)throwable;
            return this.create(throwable, e.getStatus().getCode(), e.getTrailers());
        }
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException e = (StatusRuntimeException)throwable;
            return this.create(throwable, e.getStatus().getCode(), e.getTrailers());
        }
        if (throwable instanceof ApiException) {
            return (ApiException)throwable;
        }
        return ApiExceptionFactory.createException(throwable, GrpcStatusCode.of(Status.Code.UNKNOWN), false);
    }

    private ApiException create(Throwable throwable, Status.Code statusCode, Metadata metadata) {
        Status status;
        boolean canRetry = this.retryableCodes.contains((Object)GrpcStatusCode.grpcCodeToStatusCode(statusCode));
        GrpcStatusCode grpcStatusCode = GrpcStatusCode.of(statusCode);
        if (metadata == null) {
            return ApiExceptionFactory.createException(throwable, grpcStatusCode, canRetry);
        }
        byte[] bytes = metadata.get(Metadata.Key.of(ERROR_DETAIL_KEY, Metadata.BINARY_BYTE_MARSHALLER));
        if (bytes == null) {
            return ApiExceptionFactory.createException(throwable, grpcStatusCode, canRetry);
        }
        try {
            status = Status.parseFrom(bytes);
        }
        catch (InvalidProtocolBufferException e) {
            return ApiExceptionFactory.createException(throwable, grpcStatusCode, canRetry);
        }
        ErrorDetails.Builder errorDetailsBuilder = ErrorDetails.builder();
        errorDetailsBuilder.setRawErrorMessages(status.getDetailsList());
        return ApiExceptionFactory.createException(throwable, grpcStatusCode, canRetry, errorDetailsBuilder.build());
    }
}

