/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.client.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import net.snowflake.client.jdbc.internal.google.api.client.util.ClassInfo;
import net.snowflake.client.jdbc.internal.google.api.client.util.Data;
import net.snowflake.client.jdbc.internal.google.api.client.util.Key;
import net.snowflake.client.jdbc.internal.google.api.client.util.NullValue;
import net.snowflake.client.jdbc.internal.google.api.client.util.Preconditions;
import net.snowflake.client.jdbc.internal.google.api.client.util.Value;
import net.snowflake.client.jdbc.internal.google.common.base.Ascii;

public class FieldInfo {
    private static final Map<Field, FieldInfo> CACHE = new WeakHashMap<Field, FieldInfo>();
    private final boolean isPrimitive;
    private final Field field;
    private final Method[] setters;
    private final String name;

    public static FieldInfo of(Enum<?> enumValue) {
        try {
            FieldInfo result = FieldInfo.of(enumValue.getClass().getField(enumValue.name()));
            Preconditions.checkArgument(result != null, "enum constant missing @Value or @NullValue annotation: %s", enumValue);
            return result;
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static FieldInfo of(Field field) {
        if (field == null) {
            return null;
        }
        Map<Field, FieldInfo> map = CACHE;
        synchronized (map) {
            FieldInfo fieldInfo = CACHE.get(field);
            boolean isEnumContant = field.isEnumConstant();
            if (fieldInfo == null && (isEnumContant || !Modifier.isStatic(field.getModifiers()))) {
                String fieldName;
                if (isEnumContant) {
                    Value value = field.getAnnotation(Value.class);
                    if (value != null) {
                        fieldName = value.value();
                    } else {
                        NullValue nullValue = field.getAnnotation(NullValue.class);
                        if (nullValue == null) {
                            return null;
                        }
                        fieldName = null;
                    }
                } else {
                    Key key = field.getAnnotation(Key.class);
                    if (key == null) {
                        return null;
                    }
                    fieldName = key.value();
                    field.setAccessible(true);
                }
                if ("##default".equals(fieldName)) {
                    fieldName = field.getName();
                }
                fieldInfo = new FieldInfo(field, fieldName);
                CACHE.put(field, fieldInfo);
            }
            return fieldInfo;
        }
    }

    FieldInfo(Field field, String name) {
        this.field = field;
        this.name = name == null ? null : name.intern();
        this.isPrimitive = Data.isPrimitive(this.getType());
        this.setters = this.settersMethodForField(field);
    }

    private Method[] settersMethodForField(Field field) {
        ArrayList<Method> methods = new ArrayList<Method>();
        String fieldSetter = "set" + Ascii.toUpperCase(field.getName().substring(0, 1));
        if (field.getName().length() > 1) {
            fieldSetter = fieldSetter + field.getName().substring(1);
        }
        for (Method method : field.getDeclaringClass().getDeclaredMethods()) {
            if (method.getParameterTypes().length != 1) continue;
            if (method.getName().equals(fieldSetter)) {
                methods.add(0, method);
                continue;
            }
            if (!Ascii.toLowerCase(method.getName()).equals(Ascii.toLowerCase(fieldSetter))) continue;
            methods.add(method);
        }
        return methods.toArray(new Method[0]);
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.field.getModifiers());
    }

    public boolean isPrimitive() {
        return this.isPrimitive;
    }

    public Object getValue(Object obj) {
        return FieldInfo.getFieldValue(this.field, obj);
    }

    public void setValue(Object obj, Object value) {
        for (Method method : this.setters) {
            if (value != null && !method.getParameterTypes()[0].isAssignableFrom(value.getClass())) continue;
            try {
                method.invoke(obj, value);
                return;
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
        FieldInfo.setFieldValue(this.field, obj, value);
    }

    public ClassInfo getClassInfo() {
        return ClassInfo.of(this.field.getDeclaringClass());
    }

    public <T extends Enum<T>> T enumValue() {
        return (T)Enum.valueOf(this.field.getDeclaringClass(), this.field.getName());
    }

    public static Object getFieldValue(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void setFieldValue(Field field, Object obj, Object value) {
        if (Modifier.isFinal(field.getModifiers())) {
            Object finalValue = FieldInfo.getFieldValue(field, obj);
            if (value == null ? finalValue != null : !value.equals(finalValue)) {
                throw new IllegalArgumentException("expected final value <" + finalValue + "> but was <" + value + "> on " + field.getName() + " field in " + obj.getClass().getName());
            }
        } else {
            try {
                field.set(obj, value);
            }
            catch (SecurityException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

