/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ciba;

import java.net.URI;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.com.nimbusds.common.contenttype.ContentType;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ProtectedResourceRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ciba.AuthRequestID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

@Immutable
public class CIBAPingCallback
extends ProtectedResourceRequest {
    private final AuthRequestID authRequestID;

    public CIBAPingCallback(URI endpoint, BearerAccessToken accessToken, AuthRequestID authRequestID) {
        super(endpoint, accessToken);
        this.authRequestID = Objects.requireNonNull(authRequestID);
    }

    public AuthRequestID getAuthRequestID() {
        return this.authRequestID;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        HTTPRequest httpRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        httpRequest.setFollowRedirects(false);
        httpRequest.setAuthorization(this.getAccessToken().toAuthorizationHeader());
        httpRequest.setEntityContentType(ContentType.APPLICATION_JSON);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("auth_req_id", this.getAuthRequestID().getValue());
        httpRequest.setBody(jsonObject.toJSONString());
        return httpRequest;
    }

    public static CIBAPingCallback parse(HTTPRequest httpRequest) throws ParseException {
        URI uri = httpRequest.getURI();
        httpRequest.ensureMethod(HTTPRequest.Method.POST);
        httpRequest.ensureEntityContentType(ContentType.APPLICATION_JSON);
        BearerAccessToken accessToken = BearerAccessToken.parse(httpRequest);
        AuthRequestID authRequestID = new AuthRequestID(JSONObjectUtils.getNonBlankString(httpRequest.getBodyAsJSONObject(), "auth_req_id"));
        return new CIBAPingCallback(uri, accessToken, authRequestID);
    }
}

