/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth;

import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLSocketFactory;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.auth.TLSClientAuthentication;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.ClientID;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.StringUtils;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public class SelfSignedTLSClientAuthentication
extends TLSClientAuthentication {
    public SelfSignedTLSClientAuthentication(ClientID clientID, SSLSocketFactory sslSocketFactory) {
        super(ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH, clientID, sslSocketFactory);
    }

    public SelfSignedTLSClientAuthentication(ClientID clientID, X509Certificate certificate) {
        super(ClientAuthenticationMethod.SELF_SIGNED_TLS_CLIENT_AUTH, clientID, Objects.requireNonNull(certificate));
    }

    public static SelfSignedTLSClientAuthentication parse(HTTPRequest httpRequest) throws ParseException {
        Map params = httpRequest.getBodyAsFormParameters();
        String clientIDString = (String)MultivaluedMapUtils.getFirstValue(params, "client_id");
        if (StringUtils.isBlank(clientIDString)) {
            throw new ParseException("Missing client_id parameter");
        }
        X509Certificate cert = httpRequest.getClientX509Certificate();
        if (cert == null) {
            throw new ParseException("Missing client X.509 certificate");
        }
        return new SelfSignedTLSClientAuthentication(new ClientID(clientIDString), cert);
    }
}

