/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.VectorSchemaRoot;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.Dictionary;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.dictionary.DictionaryProvider;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.ArrowType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.DictionaryEncoding;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Schema;

public class Validator {
    public static void compareSchemas(Schema schema1, Schema schema2) {
        if (!schema2.equals(schema1)) {
            throw new IllegalArgumentException("Different schemas:\n" + schema2 + "\n" + schema1);
        }
    }

    public static void compareDictionaries(List<DictionaryEncoding> encodings1, List<DictionaryEncoding> encodings2, DictionaryProvider provider1, DictionaryProvider provider2) {
        if (encodings1.size() != encodings2.size()) {
            throw new IllegalArgumentException("Different dictionary encoding count:\n" + encodings1.size() + "\n" + encodings2.size());
        }
        for (int i = 0; i < encodings1.size(); ++i) {
            if (!encodings1.get(i).equals(encodings2.get(i))) {
                throw new IllegalArgumentException("Different dictionary encodings:\n" + encodings1.get(i) + "\n" + encodings2.get(i));
            }
            long id = encodings1.get(i).getId();
            Dictionary dict1 = provider1.lookup(id);
            Dictionary dict2 = provider2.lookup(id);
            if (dict1 == null || dict2 == null) {
                throw new IllegalArgumentException("The DictionaryProvider did not contain the required dictionary with id: " + id + "\n" + dict1 + "\n" + dict2);
            }
            try {
                Validator.compareFieldVectors(dict1.getVector(), dict2.getVector());
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Different dictionaries:\n" + dict1 + "\n" + dict2, e);
            }
        }
    }

    public static void compareDictionaryProviders(DictionaryProvider provider1, DictionaryProvider provider2) {
        ArrayList<Long> ids1 = new ArrayList<Long>(provider1.getDictionaryIds());
        ArrayList<Long> ids2 = new ArrayList<Long>(provider2.getDictionaryIds());
        Collections.sort(ids1);
        Collections.sort(ids2);
        if (!ids1.equals(ids2)) {
            throw new IllegalArgumentException("Different ids in dictionary providers:\n" + ids1 + "\n" + ids2);
        }
        Iterator iterator = ids1.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            Dictionary dict1 = provider1.lookup(id);
            Dictionary dict2 = provider2.lookup(id);
            try {
                Validator.compareFieldVectors(dict1.getVector(), dict2.getVector());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Different dictionaries:\n" + dict1 + "\n" + dict2, e);
            }
        }
    }

    public static void compareVectorSchemaRoot(VectorSchemaRoot root1, VectorSchemaRoot root2) {
        Validator.compareSchemas(root2.getSchema(), root1.getSchema());
        if (root1.getRowCount() != root2.getRowCount()) {
            throw new IllegalArgumentException("Different row count:\n" + root1.getRowCount() + " != " + root2.getRowCount());
        }
        List<FieldVector> vectors1 = root1.getFieldVectors();
        List<FieldVector> vectors2 = root2.getFieldVectors();
        if (vectors1.size() != vectors2.size()) {
            throw new IllegalArgumentException("Different column count:\n" + vectors1.toString() + "\n!=\n" + vectors2.toString());
        }
        for (int i = 0; i < vectors1.size(); ++i) {
            Validator.compareFieldVectors(vectors1.get(i), vectors2.get(i));
        }
    }

    public static void compareFieldVectors(FieldVector vector1, FieldVector vector2) {
        Field field1 = vector1.getField();
        if (!field1.equals(vector2.getField())) {
            throw new IllegalArgumentException("Different Fields:\n" + field1 + "\n!=\n" + vector2.getField());
        }
        int valueCount = vector1.getValueCount();
        if (valueCount != vector2.getValueCount()) {
            throw new IllegalArgumentException("Different value count for field " + field1 + " : " + valueCount + " != " + vector2.getValueCount());
        }
        for (int j = 0; j < valueCount; ++j) {
            Object obj1 = vector1.getObject(j);
            Object obj2 = vector2.getObject(j);
            if (Validator.equals(field1.getType(), obj1, obj2)) continue;
            throw new IllegalArgumentException("Different values in column:\n" + field1 + " at index " + j + ": " + obj1 + " != " + obj2);
        }
    }

    static boolean equals(ArrowType type, Object o1, Object o2) {
        if (type instanceof ArrowType.FloatingPoint) {
            ArrowType.FloatingPoint fpType = (ArrowType.FloatingPoint)type;
            switch (fpType.getPrecision()) {
                case DOUBLE: {
                    return Validator.equalEnough((Double)o1, (Double)o2);
                }
                case SINGLE: {
                    return Validator.equalEnough((Float)o1, (Float)o2);
                }
            }
            throw new UnsupportedOperationException("unsupported precision: " + fpType);
        }
        if (type instanceof ArrowType.Binary || type instanceof ArrowType.LargeBinary || type instanceof ArrowType.FixedSizeBinary) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        return Objects.equals(o1, o2);
    }

    static boolean equalEnough(Float f1, Float f2) {
        if (f1 == null || f2 == null) {
            return f1 == null && f2 == null;
        }
        if (f1.isNaN()) {
            return f2.isNaN();
        }
        if (f1.isInfinite()) {
            return f2.isInfinite() && Math.signum(f1.floatValue()) == Math.signum(f2.floatValue());
        }
        float average = Math.abs((f1.floatValue() + f2.floatValue()) / 2.0f);
        float differenceScaled = Math.abs(f1.floatValue() - f2.floatValue()) / (average == 0.0f ? 1.0f : average);
        return differenceScaled < 1.0E-6f;
    }

    static boolean equalEnough(Double f1, Double f2) {
        if (f1 == null || f2 == null) {
            return f1 == null && f2 == null;
        }
        if (f1.isNaN()) {
            return f2.isNaN();
        }
        if (f1.isInfinite()) {
            return f2.isInfinite() && Math.signum(f1) == Math.signum(f2);
        }
        double average = Math.abs((f1 + f2) / 2.0);
        double differenceScaled = Math.abs(f1 - f2) / (average == 0.0 ? 1.0 : average);
        return differenceScaled < 1.0E-12;
    }
}

