/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public interface SnowflakeResultSetSerializable {
    @Deprecated
    public ResultSet getResultSet() throws SQLException;

    @Deprecated
    public ResultSet getResultSet(Properties var1) throws SQLException;

    public ResultSet getResultSet(ResultSetRetrieveConfig var1) throws SQLException;

    public long getRowCount() throws SQLException;

    public long getCompressedDataSizeInBytes() throws SQLException;

    public long getUncompressedDataSizeInBytes() throws SQLException;

    public static class ResultSetRetrieveConfig {
        private Properties proxyProperties;
        private String sfFullURL;

        public ResultSetRetrieveConfig(Builder builder) {
            this.proxyProperties = builder.proxyProperties;
            this.sfFullURL = builder.sfFullURL;
        }

        public Properties getProxyProperties() {
            return this.proxyProperties;
        }

        public String getSfFullURL() {
            return this.sfFullURL;
        }

        public static class Builder {
            private Properties proxyProperties = null;
            private String sfFullURL = null;

            private Builder() {
            }

            public static Builder newInstance() {
                return new Builder();
            }

            public ResultSetRetrieveConfig build() throws IllegalArgumentException {
                if (this.sfFullURL == null || !this.sfFullURL.toLowerCase().startsWith("http")) {
                    throw new IllegalArgumentException("The SF URL must include protocol. The invalid is: " + this.sfFullURL);
                }
                return new ResultSetRetrieveConfig(this);
            }

            public Builder setProxyProperties(Properties proxyProperties) {
                this.proxyProperties = proxyProperties;
                return this;
            }

            public Builder setSfFullURL(String sfFullURL) {
                this.sfFullURL = sfFullURL;
                return this;
            }
        }
    }
}

