/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.nio.ByteBuffer;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeTimestampWithTimezone;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;

public class BigIntToTimeConverter
extends AbstractArrowVectorConverter {
    private BigIntVector bigIntVector;
    protected ByteBuffer byteBuf = ByteBuffer.allocate(8);

    public BigIntToTimeConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.TIME.name(), fieldVector, columnIndex, context);
        this.bigIntVector = (BigIntVector)fieldVector;
    }

    private SFTime toSFTime(int index) {
        long val = this.bigIntVector.getDataBuffer().getLong(index * 8);
        return SFTime.fromFractionalSeconds(val, this.context.getScale(this.columnIndex));
    }

    @Override
    public Time toTime(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        long val = this.bigIntVector.getDataBuffer().getLong(index * 8);
        return BigIntToTimeConverter.getTime(val, this.context.getScale(this.columnIndex), this.useSessionTimezone);
    }

    public static Time getTime(long value, int scale, boolean useSessionTimezone) throws SFException {
        SFTime sfTime = SFTime.fromFractionalSeconds(value, scale);
        Time ts = new Time(sfTime.getFractionalSeconds(3));
        if (useSessionTimezone) {
            ts = SnowflakeUtil.getTimeInSessionTimezone(SnowflakeUtil.getSecondsFromMillis(ts.getTime()), sfTime.getNanosecondsWithinSecond());
        }
        return ts;
    }

    @Override
    public String toString(int index) throws SFException {
        if (this.context.getTimeFormatter() == null) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "missing time formatter");
        }
        return this.isNull(index) ? null : ResultUtil.getSFTimeAsString(this.toSFTime(index), this.context.getScale(this.columnIndex), this.context.getTimeFormatter());
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.isNull(index) ? null : this.toTime(index);
    }

    @Override
    public Timestamp toTimestamp(int index, TimeZone tz) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        if (this.useSessionTimezone) {
            SFTime sfTime = this.toSFTime(index);
            return new SnowflakeTimestampWithTimezone(sfTime.getFractionalSeconds(3), sfTime.getNanosecondsWithinSecond(), TimeZone.getTimeZone("UTC"));
        }
        return new Timestamp(this.toTime(index).getTime());
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        if (this.isNull(index)) {
            return false;
        }
        Time val = this.toTime(index);
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "boolean", val);
    }
}

