/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeTimestampWithTimezone;
import net.snowflake.client.jdbc.internal.snowflake.common.core.CalendarCache;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class ArrowResultUtil {
    private static final SFLogger logger = SFLoggerFactory.getLogger(ArrowResultUtil.class);
    private static final int[] POWERS_OF_10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    public static final int MAX_SCALE_POWERS_OF_10 = 9;

    public static long powerOfTen(int pow) {
        long val = 1L;
        while (pow > 9) {
            val *= (long)POWERS_OF_10[9];
            pow -= 9;
        }
        return val * (long)POWERS_OF_10[pow];
    }

    public static String getStringFormat(int scale) {
        StringBuilder sb = new StringBuilder();
        return sb.append("%.").append(scale).append('f').toString();
    }

    public static Date getDate(int day) {
        LocalDate localDate = LocalDate.ofEpochDay(day);
        return Date.valueOf(localDate);
    }

    public static Date getDate(int day, TimeZone oldTz, TimeZone newTz) throws SFException {
        try {
            long milliSecsSinceEpoch = (long)day * 86400000L;
            long milliSecsSinceEpochNew = milliSecsSinceEpoch + ArrowResultUtil.moveToTimeZoneOffset(milliSecsSinceEpoch, oldTz, newTz);
            Date preDate = new Date(milliSecsSinceEpochNew);
            Date newDate = ResultUtil.adjustDate(preDate);
            Object[] objectArray = new Object[2];
            objectArray[0] = preDate::toString;
            objectArray[1] = newDate::toString;
            logger.debug("Adjust date from {} to {}", objectArray);
            return newDate;
        }
        catch (NumberFormatException ex) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "Invalid date value: " + day);
        }
    }

    private static long moveToTimeZoneOffset(long milliSecsSinceEpoch, TimeZone oldTZ, TimeZone newTZ) {
        if (oldTZ.hasSameRules(newTZ)) {
            return 0L;
        }
        int offsetMillisInOldTZ = oldTZ.getOffset(milliSecsSinceEpoch);
        GregorianCalendar calendar = CalendarCache.get(oldTZ);
        calendar.setTimeInMillis(milliSecsSinceEpoch);
        int millisecondWithinDay = ((calendar.get(11) * 60 + calendar.get(12)) * 60 + calendar.get(13)) * 1000 + calendar.get(14);
        int era = calendar.get(0);
        int year = calendar.get(1);
        int month = calendar.get(2);
        int dayOfMonth = calendar.get(5);
        int dayOfWeek = calendar.get(7);
        int offsetMillisInNewTZ = newTZ.getOffset(era, year, month, dayOfMonth, dayOfWeek, millisecondWithinDay);
        int offsetMillis = offsetMillisInOldTZ - offsetMillisInNewTZ;
        return offsetMillis;
    }

    public static Timestamp moveToTimeZone(Timestamp ts, TimeZone oldTZ, TimeZone newTZ) {
        long offset = ArrowResultUtil.moveToTimeZoneOffset(ts.getTime(), oldTZ, newTZ);
        if (offset == 0L) {
            return ts;
        }
        int nanos = ts.getNanos();
        ts = new Timestamp(ts.getTime() + offset);
        ts.setNanos(nanos);
        return ts;
    }

    public static Timestamp toJavaTimestamp(long epoch, int scale) {
        return ArrowResultUtil.toJavaTimestamp(epoch, scale, TimeZone.getDefault(), false);
    }

    @SnowflakeJdbcInternalApi
    public static Timestamp toJavaTimestamp(long epoch, int scale, TimeZone sessionTimezone, boolean useSessionTimezone) {
        long seconds = epoch / ArrowResultUtil.powerOfTen(scale);
        int fraction = (int)(epoch % ArrowResultUtil.powerOfTen(scale) * ArrowResultUtil.powerOfTen(9 - scale));
        if (fraction < 0) {
            --seconds;
            fraction += 1000000000;
        }
        return ArrowResultUtil.createTimestamp(seconds, fraction, sessionTimezone, useSessionTimezone);
    }

    public static boolean isTimestampOverflow(long seconds) {
        return seconds < Long.MIN_VALUE / ArrowResultUtil.powerOfTen(3) || seconds > Long.MAX_VALUE / ArrowResultUtil.powerOfTen(3);
    }

    public static Timestamp createTimestamp(long seconds, int fraction, TimeZone timezone, boolean useSessionTz) {
        if (useSessionTz) {
            return new SnowflakeTimestampWithTimezone(seconds * ArrowResultUtil.powerOfTen(3), fraction, timezone);
        }
        Timestamp ts = new Timestamp(seconds * ArrowResultUtil.powerOfTen(3));
        ts.setNanos(fraction);
        return ts;
    }
}

