/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;

public class UUIDUtils {
    static Boolean newUUIDEnabled = true;

    public static UUID getUUID() {
        if (newUUIDEnabled.booleanValue()) {
            return UUIDUtils.UUIDImpl();
        }
        return UUID.randomUUID();
    }

    private static UUID UUIDImpl() {
        int i;
        byte[] randomBytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        long msb = 0L;
        long lsb = 0L;
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(randomBytes[i] & 0xFF);
        }
        return new UUID(msb, lsb);
    }
}

