/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import net.snowflake.client.core.Event;
import net.snowflake.client.jdbc.SnowflakeUtil;

public class BasicEvent
extends Event {
    private static final String requestId = "requestId: %s";
    private static final String numPings = "numberPings: %d";
    private static final String jobId = "jobId: %s";
    private static final String chunkIdx = "chunkIndex: %d";
    private static final String EVENT_DUMP_PROP = "snowflake.dump_events";
    private static final Boolean doDump = SnowflakeUtil.systemGetProperty("snowflake.dump_events") != null;

    public BasicEvent(Event.EventType type, String message) {
        super(type, message);
    }

    @Override
    public void flush() {
        if (doDump.booleanValue()) {
            // empty if block
        }
    }

    public static enum QueryState {
        QUERY_STARTED(1, "Query Started", "{requestId: %s}"),
        SENDING_QUERY(2, "Sending Query", "{requestId: %s}"),
        WAITING_FOR_RESULT(3, "Waiting for Result", "{requestId: %s,numberPings: %d}"),
        PROCESSING_RESULT(4, "Processing Result", "{requestId: %s}"),
        CONSUMING_RESULT(5, "Consuming Result", "{jobId: %s,chunkIndex: %d}"),
        QUERY_ENDED(6, "Query ended", "{requestId: %s}"),
        GETTING_FILES(8, "Getting Files", "{requestId: %s}"),
        PUTTING_FILES(9, "Putting Files", "{requestId: %s}");

        private final int id;
        private final String description;
        private final String argString;

        private QueryState(int id, String description, String argString) {
            this.id = id;
            this.description = description;
            this.argString = argString;
        }

        public int getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public String getArgString() {
            return this.argString;
        }
    }
}

