/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.diagram.options;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.command.text.diagram.options.DiagramOptions;
import schemacrawler.tools.command.text.schema.options.BaseSchemaTextOptionsBuilder;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.PropertiesUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public final class DiagramOptionsBuilder
extends BaseSchemaTextOptionsBuilder<DiagramOptionsBuilder, DiagramOptions> {
    protected static final String SCHEMACRAWLER_GRAPH_PREFIX = "schemacrawler.graph.";
    private static final String GRAPH_SHOW_PRIMARY_KEY_CARDINALITY = "schemacrawler.graph.show.primarykey.cardinality";
    private static final String GRAPH_SHOW_FOREIGN_KEY_CARDINALITY = "schemacrawler.graph.show.foreignkey.cardinality";
    private static final String GRAPH_SHOW_FOREIGN_KEY_FILTERED_TABLES = "schemacrawler.graph.show.foreignkey.filtered_tables";
    private static final String GRAPH_GRAPHVIZ_OPTS = "schemacrawler.graph.graphviz_opts";
    private static final String SC_GRAPHVIZ_OPTS = "SC_GRAPHVIZ_OPTS";
    private static final String GRAPH_GRAPHVIZ_ATTRIBUTES = "schemacrawler.graph.graphviz";
    private static final Logger LOGGER = Logger.getLogger(DiagramOptions.class.getName());
    protected List<String> graphvizOpts = new ArrayList<String>();
    protected Map<String, String> graphvizAttributes = DiagramOptionsBuilder.makeDefaultGraphvizAttributes();
    protected boolean isShowForeignKeyCardinality = true;
    protected boolean isShowPrimaryKeyCardinality = true;
    protected boolean isShowFilteredTables = true;

    public static DiagramOptionsBuilder builder() {
        return new DiagramOptionsBuilder();
    }

    public static DiagramOptionsBuilder builder(DiagramOptions options) {
        return new DiagramOptionsBuilder().fromOptions(options);
    }

    private static Map<String, String> makeDefaultGraphvizAttributes() {
        HashMap<String, String> graphvizAttributes = new HashMap<String, String>();
        String GRAPH = "graph.";
        graphvizAttributes.put("graph.rankdir", "RL");
        graphvizAttributes.put("graph.labeljust", "r");
        graphvizAttributes.put("graph.fontname", "Helvetica");
        String NODE = "node.";
        graphvizAttributes.put("node.shape", "none");
        graphvizAttributes.put("node.fontname", "Helvetica");
        String EDGE = "edge.";
        graphvizAttributes.put("edge.fontname", "Helvetica");
        return graphvizAttributes;
    }

    private DiagramOptionsBuilder() {
    }

    @Override
    public DiagramOptionsBuilder fromConfig(Config config) {
        if (config == null) {
            return this;
        }
        super.fromConfig(config);
        this.isShowPrimaryKeyCardinality = config.getBooleanValue(GRAPH_SHOW_PRIMARY_KEY_CARDINALITY, true);
        this.isShowForeignKeyCardinality = config.getBooleanValue(GRAPH_SHOW_FOREIGN_KEY_CARDINALITY, true);
        this.isShowFilteredTables = config.getBooleanValue(GRAPH_SHOW_FOREIGN_KEY_FILTERED_TABLES, true);
        this.graphvizOpts = this.listGraphvizOpts(this.readGraphvizOpts(config));
        Map<String, String> graphvizAttributes = this.readGraphvizAttributes(config);
        if (graphvizAttributes != null) {
            this.graphvizAttributes = graphvizAttributes;
        }
        return this;
    }

    @Override
    public DiagramOptionsBuilder fromOptions(DiagramOptions options) {
        if (options == null) {
            return this;
        }
        super.fromOptions(options);
        this.isShowPrimaryKeyCardinality = options.isShowPrimaryKeyCardinality();
        this.isShowForeignKeyCardinality = options.isShowForeignKeyCardinality();
        this.isShowFilteredTables = options.isShowFilteredTables();
        this.graphvizOpts = options.getGraphvizOpts();
        this.graphvizAttributes = options.getGraphvizAttributes();
        return this;
    }

    public DiagramOptionsBuilder showFilteredTables() {
        return this.showFilteredTables(true);
    }

    public DiagramOptionsBuilder showFilteredTables(boolean value) {
        this.isShowFilteredTables = value;
        return this;
    }

    public DiagramOptionsBuilder showForeignKeyCardinality() {
        return this.showForeignKeyCardinality(true);
    }

    public DiagramOptionsBuilder showForeignKeyCardinality(boolean value) {
        this.isShowForeignKeyCardinality = value;
        return this;
    }

    public DiagramOptionsBuilder showPrimaryKeyCardinality() {
        return this.showPrimaryKeyCardinality(true);
    }

    public DiagramOptionsBuilder showPrimaryKeyCardinality(boolean value) {
        this.isShowPrimaryKeyCardinality = value;
        return this;
    }

    @Override
    public Config toConfig() {
        Config config = super.toConfig();
        config.put(GRAPH_SHOW_PRIMARY_KEY_CARDINALITY, this.isShowPrimaryKeyCardinality);
        config.put(GRAPH_SHOW_FOREIGN_KEY_CARDINALITY, this.isShowForeignKeyCardinality);
        config.put(GRAPH_SHOW_FOREIGN_KEY_FILTERED_TABLES, this.isShowFilteredTables);
        config.put(GRAPH_GRAPHVIZ_OPTS, Utility.join(this.graphvizOpts, " "));
        this.graphvizAttributesToConfig(this.graphvizAttributes, config);
        return config;
    }

    @Override
    public DiagramOptions toOptions() {
        return new DiagramOptions(this);
    }

    public DiagramOptionsBuilder withGraphvizAttributes(Map<String, String> graphvizAttributes) {
        this.graphvizAttributes = graphvizAttributes == null ? DiagramOptionsBuilder.makeDefaultGraphvizAttributes() : graphvizAttributes;
        return this;
    }

    public DiagramOptionsBuilder withGraphvizOpts(List<String> graphvizOpts) {
        this.graphvizOpts = graphvizOpts == null ? new ArrayList<String>() : graphvizOpts;
        return this;
    }

    private void graphvizAttributesToConfig(Map<String, String> graphvizAttributes, Config config) {
        for (Map.Entry<String, String> graphvizAttribute : graphvizAttributes.entrySet()) {
            String fullKey = "%s.%s".formatted(GRAPH_GRAPHVIZ_ATTRIBUTES, graphvizAttribute.getKey());
            String value = graphvizAttribute.getValue();
            config.put(fullKey, value);
        }
    }

    private List<String> listGraphvizOpts(String graphVizOptions) {
        if (Utility.isBlank(graphVizOptions)) {
            return new ArrayList<String>();
        }
        List<String> graphVizOptionsList = Arrays.asList(graphVizOptions.split("\\s+"));
        return graphVizOptionsList;
    }

    private Map<String, String> readGraphvizAttributes(Config config) {
        if (config == null) {
            return null;
        }
        Map<String, Object> subMap = config.getSubMap(GRAPH_GRAPHVIZ_ATTRIBUTES);
        HashMap<String, String> graphvizAttributes = new HashMap<String, String>();
        for (Map.Entry<String, Object> subMapEntry : subMap.entrySet()) {
            String key = subMapEntry.getKey();
            String value = String.valueOf(subMapEntry.getValue());
            graphvizAttributes.put(key, value);
        }
        if (graphvizAttributes.isEmpty()) {
            return null;
        }
        return graphvizAttributes;
    }

    private String readGraphvizOpts(Config config) {
        String scGraphvizOptsCfg = config.getStringValue(GRAPH_GRAPHVIZ_OPTS, "");
        if (!Utility.isBlank(scGraphvizOptsCfg)) {
            LOGGER.log(Level.CONFIG, new StringFormat("Using additional Graphviz command-line options from config <%s>", scGraphvizOptsCfg));
            return scGraphvizOptsCfg;
        }
        return PropertiesUtility.getSystemConfigurationProperty(SC_GRAPHVIZ_OPTS, "");
    }
}

