/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.json;

import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringBuilderUTF32;
import com.oracle.truffle.api.strings.TruffleStringIterator;

public abstract class JSONUtils {
    private static final TruffleString T_ESC_BACKSLASH = PythonUtils.tsLiteral("\\\\");
    private static final TruffleString T_ESC_QUOTE = PythonUtils.tsLiteral("\\\"");
    private static final TruffleString T_ESC_B = PythonUtils.tsLiteral("\\b");
    private static final TruffleString T_ESC_F = PythonUtils.tsLiteral("\\f");
    private static final TruffleString T_ESC_N = PythonUtils.tsLiteral("\\n");
    private static final TruffleString T_ESC_R = PythonUtils.tsLiteral("\\r");
    private static final TruffleString T_ESC_T = PythonUtils.tsLiteral("\\t");

    private JSONUtils() {
    }

    static void appendStringUncached(TruffleString ts, TruffleStringBuilderUTF32 builder, boolean asciiOnly) {
        builder.appendCodePointUncached(34);
        TruffleStringIterator it = ts.createCodePointIteratorUncached(PythonUtils.TS_ENCODING);
        block9: while (it.hasNext()) {
            int c = it.nextUncached(PythonUtils.TS_ENCODING);
            switch (c) {
                case 92: {
                    builder.appendStringUncached(T_ESC_BACKSLASH);
                    continue block9;
                }
                case 34: {
                    builder.appendStringUncached(T_ESC_QUOTE);
                    continue block9;
                }
                case 8: {
                    builder.appendStringUncached(T_ESC_B);
                    continue block9;
                }
                case 12: {
                    builder.appendStringUncached(T_ESC_F);
                    continue block9;
                }
                case 10: {
                    builder.appendStringUncached(T_ESC_N);
                    continue block9;
                }
                case 13: {
                    builder.appendStringUncached(T_ESC_R);
                    continue block9;
                }
                case 9: {
                    builder.appendStringUncached(T_ESC_T);
                    continue block9;
                }
            }
            if (c <= 31 || asciiOnly && c > 126) {
                if (c <= 65535) {
                    JSONUtils.appendEscapedUtf16Uncached((char)c, builder);
                    continue;
                }
                JSONUtils.appendEscapedUtf16Uncached((char)(55296 + (c - 65536 >> 10)), builder);
                JSONUtils.appendEscapedUtf16Uncached((char)(56320 + (c - 65536 & 0x3FF)), builder);
                continue;
            }
            builder.appendCodePointUncached(c, 1, true);
        }
        builder.appendCodePointUncached(34);
    }

    private static void appendEscapedUtf16Uncached(char c, TruffleStringBuilderUTF32 builder) {
        builder.appendStringUncached(TruffleString.fromByteArrayUncached((byte[])new byte[]{92, 117, BytesUtils.HEXDIGITS[c >> 12 & 0xF], BytesUtils.HEXDIGITS[c >> 8 & 0xF], BytesUtils.HEXDIGITS[c >> 4 & 0xF], BytesUtils.HEXDIGITS[c & 0xF]}, (TruffleString.Encoding)TruffleString.Encoding.US_ASCII));
    }

    static void appendString(TruffleString s, TruffleStringIterator it, TruffleStringBuilder builder, boolean asciiOnly, TruffleStringIterator.NextNode nextNode, TruffleStringBuilder.AppendCodePointNode appendCodePointNode, TruffleStringBuilder.AppendStringNode appendStringNode, TruffleString.SubstringNode substringNode) {
        appendCodePointNode.execute(builder, 34, 1, true);
        int chunkStart = 0;
        int currentIndex = 0;
        while (it.hasNext()) {
            int c = nextNode.execute(it, PythonUtils.TS_ENCODING);
            switch (c) {
                case 92: {
                    JSONUtils.appendSubstring(builder, s, chunkStart, currentIndex, appendStringNode, substringNode);
                    chunkStart = currentIndex + 1;
                    appendStringNode.execute(builder, (AbstractTruffleString)T_ESC_BACKSLASH);
                    break;
                }
                case 34: {
                    JSONUtils.appendSubstring(builder, s, chunkStart, currentIndex, appendStringNode, substringNode);
                    chunkStart = currentIndex + 1;
                    appendStringNode.execute(builder, (AbstractTruffleString)T_ESC_QUOTE);
                    break;
                }
                case 8: {
                    JSONUtils.appendSubstring(builder, s, chunkStart, currentIndex, appendStringNode, substringNode);
                    chunkStart = currentIndex + 1;
                    appendStringNode.execute(builder, (AbstractTruffleString)T_ESC_B);
                    break;
                }
                case 12: {
                    JSONUtils.appendSubstring(builder, s, chunkStart, currentIndex, appendStringNode, substringNode);
                    chunkStart = currentIndex + 1;
                    appendStringNode.execute(builder, (AbstractTruffleString)T_ESC_F);
                    break;
                }
                case 10: {
                    JSONUtils.appendSubstring(builder, s, chunkStart, currentIndex, appendStringNode, substringNode);
                    chunkStart = currentIndex + 1;
                    appendStringNode.execute(builder, (AbstractTruffleString)T_ESC_N);
                    break;
                }
                case 13: {
                    JSONUtils.appendSubstring(builder, s, chunkStart, currentIndex, appendStringNode, substringNode);
                    chunkStart = currentIndex + 1;
                    appendStringNode.execute(builder, (AbstractTruffleString)T_ESC_R);
                    break;
                }
                case 9: {
                    JSONUtils.appendSubstring(builder, s, chunkStart, currentIndex, appendStringNode, substringNode);
                    chunkStart = currentIndex + 1;
                    appendStringNode.execute(builder, (AbstractTruffleString)T_ESC_T);
                    break;
                }
                default: {
                    if (c > 31 && (!asciiOnly || c <= 126)) break;
                    JSONUtils.appendSubstring(builder, s, chunkStart, currentIndex, appendStringNode, substringNode);
                    chunkStart = currentIndex + 1;
                    if (c <= 65535) {
                        JSONUtils.appendEscapedUtf16((char)c, builder, appendCodePointNode);
                        break;
                    }
                    JSONUtils.appendEscapedUtf16((char)(55296 + (c - 65536 >> 10)), builder, appendCodePointNode);
                    JSONUtils.appendEscapedUtf16((char)(56320 + (c - 65536 & 0x3FF)), builder, appendCodePointNode);
                }
            }
            ++currentIndex;
        }
        JSONUtils.appendSubstring(builder, s, chunkStart, currentIndex, appendStringNode, substringNode);
        appendCodePointNode.execute(builder, 34, 1, true);
    }

    private static void appendSubstring(TruffleStringBuilder builder, TruffleString s, int startIndex, int endIndex, TruffleStringBuilder.AppendStringNode appendStringNode, TruffleString.SubstringNode substringNode) {
        if (startIndex < endIndex) {
            appendStringNode.execute(builder, (AbstractTruffleString)substringNode.execute((AbstractTruffleString)s, startIndex, endIndex - startIndex, PythonUtils.TS_ENCODING, true));
        }
    }

    private static void appendEscapedUtf16(char c, TruffleStringBuilder builder, TruffleStringBuilder.AppendCodePointNode appendCodePointNode) {
        appendCodePointNode.execute(builder, 92, 1, true);
        appendCodePointNode.execute(builder, 117, 1, true);
        appendCodePointNode.execute(builder, (int)BytesUtils.HEXDIGITS[c >> 12 & 0xF], 1, true);
        appendCodePointNode.execute(builder, (int)BytesUtils.HEXDIGITS[c >> 8 & 0xF], 1, true);
        appendCodePointNode.execute(builder, (int)BytesUtils.HEXDIGITS[c >> 4 & 0xF], 1, true);
        appendCodePointNode.execute(builder, (int)BytesUtils.HEXDIGITS[c & 0xF], 1, true);
    }
}

