/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.repository;

import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.pdqcompare.PDQComparator;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.PureQueryUtility;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.cmx.tools.internal.repository.DefaultActionProcessor;
import com.ibm.db2.cmx.tools.internal.repository.HTMLReportGenerator;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ReportActionProcessor
extends DefaultActionProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PureQueryUtility.UtilityResult processAction(PossibleArgs possibleArgs, ArtifactOptionsSet artifactOptionsSet, Connection connection, String string, RepositoryVersion repositoryVersion, PrintWriter printWriter) throws MetadataException, Exception {
        PureQueryUtility.UtilityResult utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
        PossibleArgs.PredefinedOptionValues predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.REPORT);
        String string2 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.FILE);
        Writer writer = string2 != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "UTF-8") : printWriter;
        try {
            if (PossibleArgs.PredefinedOptionValues.REPOSITORY_DATA.compareTo(predefinedOptionValues) == 0) {
                new HTMLReportGenerator(artifactOptionsSet).generateReport(connection, string, writer);
            } else if (PossibleArgs.PredefinedOptionValues.PUREQUERY_XML_CHANGES.compareTo(predefinedOptionValues) == 0) {
                String string3 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.OLD_PUREQUERY_XML);
                String string4 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.NEW_PUREQUERY_XML);
                String string5 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.RUNTIME_GROUP_ID);
                if (string5 != null) {
                    String string6 = null;
                    String string7 = null;
                    try {
                        String string8 = "SELECT name, version FROM " + string + ".metadatagroup WHERE metadatagroup_key = ?";
                        PreparedStatement preparedStatement = connection.prepareStatement(string8);
                        preparedStatement.setInt(1, Integer.parseInt(string5));
                        ResultSet resultSet = preparedStatement.executeQuery();
                        while (resultSet.next()) {
                            string6 = resultSet.getString("NAME");
                            Integer n2 = resultSet.getInt("VERSION");
                            if (n2 == null) continue;
                            string7 = n2.toString();
                        }
                        PDQComparator.comparePDQs(string3, string4, string2, connection, string6, string7);
                    }
                    catch (SQLException sQLException) {
                        PDQComparator.comparePDQs(connection, string3, string4, writer);
                    }
                } else {
                    PDQComparator.comparePDQs(connection, string3, string4, writer);
                }
            } else if (PossibleArgs.PredefinedOptionValues.REPOSITORY_VERSION.compareTo(predefinedOptionValues) == 0) {
                if (repositoryVersion == null) {
                    String string9 = connection.getMetaData().getURL();
                    utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.FAILURE);
                    utilityResult.reason = Messages.getText("ERR_REPOSITORY_DOES_NOT_EXIST", new Object[]{string9, string, PossibleArgs.REPOSITORY_SCHEMA});
                } else {
                    if (repositoryVersion.isFullRepository()) {
                        printWriter.println(Messages.getText("MSG_REPOSITORY_VERSION_PUREQUERY_ONLY", repositoryVersion.getVersion(), repositoryVersion.getRelease(), repositoryVersion.getMod()));
                    } else {
                        printWriter.println(Messages.getText("MSG_REPOSITORY_VERSION_PUREQUERY_RUNTIME_ONLY", repositoryVersion.getVersion(), repositoryVersion.getRelease(), repositoryVersion.getMod()));
                    }
                    utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SUCCESS);
                }
            }
        }
        finally {
            if (writer != null && writer instanceof OutputStreamWriter && writer != printWriter) {
                writer.close();
            }
        }
        return utilityResult;
    }
}

