/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNode;
import com.oracle.truffle.js.nodes.interop.JSInteropGetIteratorNodeGen;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNode;
import com.oracle.truffle.js.nodes.interop.JSInteropInvokeNodeGen;
import com.oracle.truffle.js.nodes.interop.KeyInfoNode;
import com.oracle.truffle.js.nodes.interop.KeyInfoNodeGen;
import com.oracle.truffle.js.runtime.builtins.JSNumberObject;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=JSNumberObject.class)
final class JSNumberObjectGen {
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private JSNumberObjectGen() {
    }

    static {
        LibraryExport.register(JSNumberObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSNumberObject.class)
    private static final class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        static final FinalBitSet ENABLED_MESSAGES = InteropLibraryExports.createMessageBitSet(INTEROP_LIBRARY_, (String[])new String[]{"isIdenticalOrUndefined", "identityHashCode", "hasMembers", "getMembers", "readMember", "isMemberReadable", "writeMember", "isMemberModifiable", "isMemberInsertable", "removeMember", "isMemberRemovable", "invokeMember", "isMemberInvocable", "hasMemberReadSideEffects", "hasMemberWriteSideEffects", "hasIterator", "getIterator", "hasLanguage", "getLanguage", "toDisplayString", "hasMetaObject", "getMetaObject"});

        private InteropLibraryExports() {
            super(InteropLibrary.class, JSNumberObject.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSNumberObject);
            InteropLibrary uncached = (InteropLibrary)InteropLibraryExports.createDelegate(INTEROP_LIBRARY_, (Library)new Uncached());
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSNumberObject);
            return (InteropLibrary)InteropLibraryExports.createDelegate(INTEROP_LIBRARY_, (Library)new Cached(receiver));
        }

        @GeneratedBy(value=JSNumberObject.class)
        @DenyReplace
        private static final class Uncached
        extends InteropLibrary
        implements LibraryExport.DelegateExport,
        UnadoptableNode {
            protected Uncached() {
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((JSNumberObject)((Object)receiver_)).number;
            }

            public Library getDelegateExportLibrary(Object delegate_) {
                return INTEROP_LIBRARY_.getUncached(delegate_);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JSNumberObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof JSNumberObject;
            }

            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSDynamicObject arg0Value = (JSDynamicObject)((Object)arg0Value_);
                if (arg1Value instanceof JSDynamicObject) {
                    JSDynamicObject arg1Value_ = (JSDynamicObject)((Object)arg1Value);
                    return JSDynamicObject.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                return JSDynamicObject.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSDynamicObject)((Object)receiver)).identityHashCode();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMembers(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject)((Object)receiver)).hasMembers();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject)((Object)receiver)).getMembers(includeInternal);
            }

            @CompilerDirectives.TruffleBoundary
            public Object readMember(Object arg0Value_, String arg1Value) throws UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.readMember(arg1Value, (InteropLibrary)this.getParent(), JSObject.getUncachedRead(), JSObject.language((InteropLibrary)this.getParent()).bindMemberFunctions(), TruffleString.FromJavaStringNode.getUncached(), ExportValueNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.isMemberReadable(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                arg0Value.writeMember(arg1Value, arg2Value, (InteropLibrary)this.getParent(), KeyInfoNodeGen.getUncached(), ImportValueNode.getUncached(), JSObject.getUncachedWrite(), TruffleString.FromJavaStringNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.isMemberModifiable(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.isMemberInsertable(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                arg0Value.removeMember(arg1Value, TruffleString.FromJavaStringNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.isMemberRemovable(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.invokeMember(arg1Value, arg2Value, (InteropLibrary)this.getParent(), JSInteropInvokeNodeGen.getUncached(), TruffleString.FromJavaStringNode.getUncached(), ExportValueNode.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.isMemberInvocable(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.hasMemberReadSideEffects(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.hasMemberWriteSideEffects(arg1Value, KeyInfoNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasIterator(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.hasIterator((InteropLibrary)this.getParent(), JSInteropGetIteratorNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public Object getIterator(Object arg0Value_) throws UnsupportedMessageException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSObject arg0Value = (JSObject)((Object)arg0Value_);
                return arg0Value.getIterator((InteropLibrary)this.getParent(), JSInteropGetIteratorNodeGen.getUncached());
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasLanguage(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject)((Object)receiver)).hasLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject)((Object)receiver)).getLanguage();
            }

            @CompilerDirectives.TruffleBoundary
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSObject)((Object)receiver)).toDisplayString(allowSideEffects);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean hasMetaObject(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSNonProxyObject)((Object)receiver)).hasMetaObject();
            }

            @CompilerDirectives.TruffleBoundary
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSNonProxyObject)((Object)receiver)).getMetaObject();
            }
        }

        @GeneratedBy(value=JSNumberObject.class)
        private static final class Cached
        extends InteropLibrary
        implements LibraryExport.DelegateExport {
            @Node.Child
            private InteropLibrary receiverNumberInteropLibrary_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @Node.Child
            private TruffleString.FromJavaStringNode fromJavaString;
            @Node.Child
            private KeyInfoNode keyInfo;
            @Node.Child
            private JSInteropGetIteratorNode getIteratorNode;
            @Node.Child
            private ReadMemberNode_ReadMemberData readMemberNode__readMember_cache;
            @Node.Child
            private WriteMemberNode_WriteMemberData writeMemberNode__writeMember_cache;
            @Node.Child
            private InvokeMemberNode_InvokeMemberData invokeMemberNode__invokeMember_cache;

            protected Cached(Object receiver) {
                JSNumberObject castReceiver = (JSNumberObject)((Object)receiver);
                this.receiverNumberInteropLibrary_ = (InteropLibrary)INTEROP_LIBRARY_.create((Object)castReceiver.number);
            }

            public FinalBitSet getDelegateExportMessages() {
                return ENABLED_MESSAGES;
            }

            public Object readDelegateExport(Object receiver_) {
                return ((JSNumberObject)((Object)receiver_)).number;
            }

            public Library getDelegateExportLibrary(Object delegate) {
                return this.receiverNumberInteropLibrary_;
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof JSNumberObject) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                if (!(receiver instanceof JSNumberObject)) {
                    return false;
                }
                return this.receiverNumberInteropLibrary_.accepts((Object)((JSNumberObject)((Object)receiver)).number);
            }

            private boolean isIdenticalOrUndefinedFallbackGuard_(int state_0, JSDynamicObject arg0Value, Object arg1Value) {
                return (state_0 & 1) != 0 || !(arg1Value instanceof JSDynamicObject);
            }

            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 3) != 0) {
                    if ((state_0 & 1) != 0 && arg1Value instanceof JSDynamicObject) {
                        JSDynamicObject arg1Value_ = (JSDynamicObject)((Object)arg1Value);
                        return JSDynamicObject.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 2) != 0 && this.isIdenticalOrUndefinedFallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return JSDynamicObject.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            private TriState isIdenticalOrUndefinedAndSpecialize(JSDynamicObject arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof JSDynamicObject) {
                    JSDynamicObject arg1Value_ = (JSDynamicObject)((Object)arg1Value);
                    this.state_0_ = state_0 |= 1;
                    return JSDynamicObject.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                this.state_0_ = state_0 |= 2;
                return JSDynamicObject.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (receiver instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSNumberObject)((Object)receiver)).identityHashCode();
            }

            public boolean hasMembers(Object receiver) {
                assert (receiver instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSNumberObject)((Object)receiver)).hasMembers();
            }

            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert (receiver instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSNumberObject)((Object)receiver)).getMembers(includeInternal);
            }

            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                TruffleString.FromJavaStringNode fromJavaString_;
                ReadMemberNode_ReadMemberData s0_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 4) != 0 && (s0_ = this.readMemberNode__readMember_cache) != null && (fromJavaString_ = this.fromJavaString) != null) {
                    InteropLibrary self__ = (InteropLibrary)this.getParent();
                    return arg0Value.readMember(arg1Value, self__, s0_.readNode_, s0_.bindMemberFunctions_, fromJavaString_, s0_.exportNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(JSObject arg0Value, String arg1Value) throws UnknownIdentifierException {
                TruffleString.FromJavaStringNode fromJavaString_;
                int state_0 = this.state_0_;
                InteropLibrary self__ = null;
                ReadMemberNode_ReadMemberData s0_ = (ReadMemberNode_ReadMemberData)this.insert(new ReadMemberNode_ReadMemberData());
                self__ = (InteropLibrary)this.getParent();
                ReadElementNode readNode__ = (ReadElementNode)s0_.insert(ReadElementNode.create(JSObject.language(self__).getJSContext()));
                Objects.requireNonNull(readNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.readNode_ = readNode__;
                s0_.bindMemberFunctions_ = JSObject.language(self__).bindMemberFunctions();
                TruffleString.FromJavaStringNode fromJavaString__shared = this.fromJavaString;
                if (fromJavaString__shared != null) {
                    fromJavaString_ = fromJavaString__shared;
                } else {
                    fromJavaString_ = (TruffleString.FromJavaStringNode)s0_.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (fromJavaString_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.fromJavaString == null) {
                    this.fromJavaString = fromJavaString_;
                }
                ExportValueNode exportNode__ = (ExportValueNode)s0_.insert(ExportValueNode.create());
                Objects.requireNonNull(exportNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.exportNode_ = exportNode__;
                VarHandle.storeStoreFence();
                this.readMemberNode__readMember_cache = s0_;
                this.state_0_ = state_0 |= 4;
                return arg0Value.readMember(arg1Value, self__, readNode__, s0_.bindMemberFunctions_, fromJavaString_, exportNode__);
            }

            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                KeyInfoNode keyInfo_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 8) != 0 && (keyInfo_ = this.keyInfo) != null) {
                    return arg0Value.isMemberReadable(arg1Value, keyInfo_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberReadableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                KeyInfoNode keyInfo_;
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = (KeyInfoNode)this.insert(KeyInfoNodeGen.create());
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                this.state_0_ = state_0 |= 8;
                return arg0Value.isMemberReadable(arg1Value, keyInfo_);
            }

            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                TruffleString.FromJavaStringNode fromJavaString_;
                KeyInfoNode keyInfo_;
                WriteMemberNode_WriteMemberData s0_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0 && (s0_ = this.writeMemberNode__writeMember_cache) != null && (keyInfo_ = this.keyInfo) != null && (fromJavaString_ = this.fromJavaString) != null) {
                    InteropLibrary self__ = (InteropLibrary)this.getParent();
                    arg0Value.writeMember(arg1Value, arg2Value, self__, keyInfo_, s0_.castValueNode_, s0_.writeNode_, fromJavaString_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void writeMemberNode_AndSpecialize(JSObject arg0Value, String arg1Value, Object arg2Value) throws UnknownIdentifierException, UnsupportedMessageException {
                TruffleString.FromJavaStringNode fromJavaString_;
                KeyInfoNode keyInfo_;
                int state_0 = this.state_0_;
                InteropLibrary self__ = null;
                WriteMemberNode_WriteMemberData s0_ = (WriteMemberNode_WriteMemberData)this.insert(new WriteMemberNode_WriteMemberData());
                self__ = (InteropLibrary)this.getParent();
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = (KeyInfoNode)s0_.insert(KeyInfoNodeGen.create());
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    this.keyInfo = keyInfo_;
                }
                ImportValueNode castValueNode__ = (ImportValueNode)s0_.insert(ImportValueNode.create());
                Objects.requireNonNull(castValueNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.castValueNode_ = castValueNode__;
                WriteElementNode writeNode__ = (WriteElementNode)s0_.insert(WriteElementNode.createCachedInterop());
                Objects.requireNonNull(writeNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.writeNode_ = writeNode__;
                TruffleString.FromJavaStringNode fromJavaString__shared = this.fromJavaString;
                if (fromJavaString__shared != null) {
                    fromJavaString_ = fromJavaString__shared;
                } else {
                    fromJavaString_ = (TruffleString.FromJavaStringNode)s0_.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (fromJavaString_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.fromJavaString == null) {
                    this.fromJavaString = fromJavaString_;
                }
                VarHandle.storeStoreFence();
                this.writeMemberNode__writeMember_cache = s0_;
                this.state_0_ = state_0 |= 0x10;
                arg0Value.writeMember(arg1Value, arg2Value, self__, keyInfo_, castValueNode__, writeNode__, fromJavaString_);
            }

            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                KeyInfoNode keyInfo_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) != 0 && (keyInfo_ = this.keyInfo) != null) {
                    return arg0Value.isMemberModifiable(arg1Value, keyInfo_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberModifiableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                KeyInfoNode keyInfo_;
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = (KeyInfoNode)this.insert(KeyInfoNodeGen.create());
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                this.state_0_ = state_0 |= 0x20;
                return arg0Value.isMemberModifiable(arg1Value, keyInfo_);
            }

            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                KeyInfoNode keyInfo_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x40) != 0 && (keyInfo_ = this.keyInfo) != null) {
                    return arg0Value.isMemberInsertable(arg1Value, keyInfo_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInsertableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                KeyInfoNode keyInfo_;
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = (KeyInfoNode)this.insert(KeyInfoNodeGen.create());
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                this.state_0_ = state_0 |= 0x40;
                return arg0Value.isMemberInsertable(arg1Value, keyInfo_);
            }

            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                TruffleString.FromJavaStringNode fromJavaString_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x80) != 0 && (fromJavaString_ = this.fromJavaString) != null) {
                    arg0Value.removeMember(arg1Value, fromJavaString_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.removeMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private void removeMemberNode_AndSpecialize(JSObject arg0Value, String arg1Value) throws UnsupportedMessageException {
                TruffleString.FromJavaStringNode fromJavaString_;
                int state_0 = this.state_0_;
                TruffleString.FromJavaStringNode fromJavaString__shared = this.fromJavaString;
                if (fromJavaString__shared != null) {
                    fromJavaString_ = fromJavaString__shared;
                } else {
                    fromJavaString_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (fromJavaString_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.fromJavaString == null) {
                    VarHandle.storeStoreFence();
                    this.fromJavaString = fromJavaString_;
                }
                this.state_0_ = state_0 |= 0x80;
                arg0Value.removeMember(arg1Value, fromJavaString_);
            }

            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                KeyInfoNode keyInfo_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x100) != 0 && (keyInfo_ = this.keyInfo) != null) {
                    return arg0Value.isMemberRemovable(arg1Value, keyInfo_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberRemovableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberRemovableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                KeyInfoNode keyInfo_;
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = (KeyInfoNode)this.insert(KeyInfoNodeGen.create());
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                this.state_0_ = state_0 |= 0x100;
                return arg0Value.isMemberRemovable(arg1Value, keyInfo_);
            }

            public Object invokeMember(Object arg0Value_, String arg1Value, Object ... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                TruffleString.FromJavaStringNode fromJavaString_;
                InvokeMemberNode_InvokeMemberData s0_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x200) != 0 && (s0_ = this.invokeMemberNode__invokeMember_cache) != null && (fromJavaString_ = this.fromJavaString) != null) {
                    InteropLibrary self__ = (InteropLibrary)this.getParent();
                    return arg0Value.invokeMember(arg1Value, arg2Value, self__, s0_.callNode_, fromJavaString_, s0_.exportNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(JSObject arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, UnknownIdentifierException {
                TruffleString.FromJavaStringNode fromJavaString_;
                int state_0 = this.state_0_;
                InteropLibrary self__ = null;
                InvokeMemberNode_InvokeMemberData s0_ = (InvokeMemberNode_InvokeMemberData)this.insert(new InvokeMemberNode_InvokeMemberData());
                self__ = (InteropLibrary)this.getParent();
                JSInteropInvokeNode callNode__ = (JSInteropInvokeNode)s0_.insert(JSInteropInvokeNodeGen.create());
                Objects.requireNonNull(callNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.callNode_ = callNode__;
                TruffleString.FromJavaStringNode fromJavaString__shared = this.fromJavaString;
                if (fromJavaString__shared != null) {
                    fromJavaString_ = fromJavaString__shared;
                } else {
                    fromJavaString_ = (TruffleString.FromJavaStringNode)s0_.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (fromJavaString_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.fromJavaString == null) {
                    this.fromJavaString = fromJavaString_;
                }
                ExportValueNode exportNode__ = (ExportValueNode)s0_.insert(ExportValueNode.create());
                Objects.requireNonNull(exportNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.exportNode_ = exportNode__;
                VarHandle.storeStoreFence();
                this.invokeMemberNode__invokeMember_cache = s0_;
                this.state_0_ = state_0 |= 0x200;
                return arg0Value.invokeMember(arg1Value, arg2Value, self__, callNode__, fromJavaString_, exportNode__);
            }

            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                KeyInfoNode keyInfo_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x400) != 0 && (keyInfo_ = this.keyInfo) != null) {
                    return arg0Value.isMemberInvocable(arg1Value, keyInfo_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                KeyInfoNode keyInfo_;
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = (KeyInfoNode)this.insert(KeyInfoNodeGen.create());
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                this.state_0_ = state_0 |= 0x400;
                return arg0Value.isMemberInvocable(arg1Value, keyInfo_);
            }

            public boolean hasMemberReadSideEffects(Object arg0Value_, String arg1Value) {
                KeyInfoNode keyInfo_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x800) != 0 && (keyInfo_ = this.keyInfo) != null) {
                    return arg0Value.hasMemberReadSideEffects(arg1Value, keyInfo_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasMemberReadSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean hasMemberReadSideEffectsNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                KeyInfoNode keyInfo_;
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = (KeyInfoNode)this.insert(KeyInfoNodeGen.create());
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                this.state_0_ = state_0 |= 0x800;
                return arg0Value.hasMemberReadSideEffects(arg1Value, keyInfo_);
            }

            public boolean hasMemberWriteSideEffects(Object arg0Value_, String arg1Value) {
                KeyInfoNode keyInfo_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x1000) != 0 && (keyInfo_ = this.keyInfo) != null) {
                    return arg0Value.hasMemberWriteSideEffects(arg1Value, keyInfo_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasMemberWriteSideEffectsNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean hasMemberWriteSideEffectsNode_AndSpecialize(JSObject arg0Value, String arg1Value) {
                KeyInfoNode keyInfo_;
                int state_0 = this.state_0_;
                KeyInfoNode keyInfo__shared = this.keyInfo;
                if (keyInfo__shared != null) {
                    keyInfo_ = keyInfo__shared;
                } else {
                    keyInfo_ = (KeyInfoNode)this.insert(KeyInfoNodeGen.create());
                    if (keyInfo_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.keyInfo == null) {
                    VarHandle.storeStoreFence();
                    this.keyInfo = keyInfo_;
                }
                this.state_0_ = state_0 |= 0x1000;
                return arg0Value.hasMemberWriteSideEffects(arg1Value, keyInfo_);
            }

            public boolean hasIterator(Object arg0Value_) {
                JSInteropGetIteratorNode getIteratorNode_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000) != 0 && (getIteratorNode_ = this.getIteratorNode) != null) {
                    InteropLibrary self__ = (InteropLibrary)this.getParent();
                    return arg0Value.hasIterator(self__, getIteratorNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.hasIteratorNode_AndSpecialize(arg0Value);
            }

            private boolean hasIteratorNode_AndSpecialize(JSObject arg0Value) {
                JSInteropGetIteratorNode getIteratorNode_;
                int state_0 = this.state_0_;
                InteropLibrary self__ = null;
                self__ = (InteropLibrary)this.getParent();
                JSInteropGetIteratorNode getIteratorNode__shared = this.getIteratorNode;
                if (getIteratorNode__shared != null) {
                    getIteratorNode_ = getIteratorNode__shared;
                } else {
                    getIteratorNode_ = (JSInteropGetIteratorNode)this.insert(JSInteropGetIteratorNodeGen.create());
                    if (getIteratorNode_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.getIteratorNode == null) {
                    VarHandle.storeStoreFence();
                    this.getIteratorNode = getIteratorNode_;
                }
                this.state_0_ = state_0 |= 0x2000;
                return arg0Value.hasIterator(self__, getIteratorNode_);
            }

            public Object getIterator(Object arg0Value_) throws UnsupportedMessageException {
                JSInteropGetIteratorNode getIteratorNode_;
                assert (arg0Value_ instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSNumberObject arg0Value = (JSNumberObject)((Object)arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x4000) != 0 && (getIteratorNode_ = this.getIteratorNode) != null) {
                    InteropLibrary self__ = (InteropLibrary)this.getParent();
                    return arg0Value.getIterator(self__, getIteratorNode_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getIteratorNode_AndSpecialize(arg0Value);
            }

            private Object getIteratorNode_AndSpecialize(JSObject arg0Value) throws UnsupportedMessageException {
                JSInteropGetIteratorNode getIteratorNode_;
                int state_0 = this.state_0_;
                InteropLibrary self__ = null;
                self__ = (InteropLibrary)this.getParent();
                JSInteropGetIteratorNode getIteratorNode__shared = this.getIteratorNode;
                if (getIteratorNode__shared != null) {
                    getIteratorNode_ = getIteratorNode__shared;
                } else {
                    getIteratorNode_ = (JSInteropGetIteratorNode)this.insert(JSInteropGetIteratorNodeGen.create());
                    if (getIteratorNode_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.getIteratorNode == null) {
                    VarHandle.storeStoreFence();
                    this.getIteratorNode = getIteratorNode_;
                }
                this.state_0_ = state_0 |= 0x4000;
                return arg0Value.getIterator(self__, getIteratorNode_);
            }

            public boolean hasLanguage(Object receiver) {
                assert (receiver instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSNumberObject)((Object)receiver)).hasLanguage();
            }

            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert (receiver instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSNumberObject)((Object)receiver)).getLanguage();
            }

            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert (receiver instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSNumberObject)((Object)receiver)).toDisplayString(allowSideEffects);
            }

            public boolean hasMetaObject(Object receiver) {
                assert (receiver instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSNumberObject)((Object)receiver)).hasMetaObject();
            }

            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert (receiver instanceof JSNumberObject) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSNumberObject)((Object)receiver)).getMetaObject();
            }

            @GeneratedBy(value=JSObject.class)
            @DenyReplace
            private static final class ReadMemberNode_ReadMemberData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                ReadElementNode readNode_;
                @CompilerDirectives.CompilationFinal
                boolean bindMemberFunctions_;
                @Node.Child
                ExportValueNode exportNode_;

                ReadMemberNode_ReadMemberData() {
                }
            }

            @GeneratedBy(value=JSObject.class)
            @DenyReplace
            private static final class WriteMemberNode_WriteMemberData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                ImportValueNode castValueNode_;
                @Node.Child
                WriteElementNode writeNode_;

                WriteMemberNode_WriteMemberData() {
                }
            }

            @GeneratedBy(value=JSObject.class)
            @DenyReplace
            private static final class InvokeMemberNode_InvokeMemberData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                JSInteropInvokeNode callNode_;
                @Node.Child
                ExportValueNode exportNode_;

                InvokeMemberNode_InvokeMemberData() {
                }
            }
        }
    }
}

