/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.GetIteratorFromMethodNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNodeGen;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

@GenerateInline
@GenerateUncached
@ImportStatic(value={JSInteropUtil.class})
public abstract class GetIteratorNode
extends JavaScriptBaseNode {
    protected GetIteratorNode() {
    }

    public abstract IteratorRecord execute(Node var1, Object var2);

    @NeverDefault
    public static GetIteratorNode create() {
        return GetIteratorNodeGen.create();
    }

    public static GetIteratorNode getUncached() {
        return GetIteratorNodeGen.getUncached();
    }

    @Specialization
    protected static IteratorRecord doGetIterator(Node node, Object items, @Cached(value="createIteratorMethodNode()", uncached="uncachedIteratorMethodNode()", inline=false) GetMethodNode getIteratorMethodNode, @Cached GetIteratorFromMethodNode getIteratorFromMethodNode) {
        Object method = getIteratorMethodNode == null ? GetIteratorNode.getIteratorMethodUncached(items) : getIteratorMethodNode.executeWithTarget(items);
        return getIteratorFromMethodNode.execute(node, items, method);
    }

    @HostCompilerDirectives.InliningCutoff
    private static Object getIteratorMethodUncached(Object items) {
        Object obj = JSRuntime.toObject(items);
        JSDynamicObject target = obj instanceof JSDynamicObject ? (JSDynamicObject)((Object)obj) : ForeignObjectPrototypeNode.getUncached().execute(obj);
        return JSObject.getOrDefault(target, Symbol.SYMBOL_ITERATOR, obj, (Object)Undefined.instance);
    }

    @NeverDefault
    GetMethodNode createIteratorMethodNode() {
        return GetMethodNode.create(this.getJSContext(), Symbol.SYMBOL_ITERATOR);
    }

    static GetMethodNode uncachedIteratorMethodNode() {
        return null;
    }
}

