/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.formatting;

import com.oracle.graal.python.runtime.formatting.FloatFormatter;
import com.oracle.graal.python.runtime.formatting.FormattingBuffer;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.truffle.api.nodes.Node;

public class ComplexFormatter
extends InternalFormat.Formatter {
    private final FloatFormatter reFormatter;
    private final FloatFormatter imFormatter;

    protected ComplexFormatter(FormattingBuffer result, InternalFormat.Spec spec, Node raisingNode) {
        super(result, spec, raisingNode);
        InternalFormat.Spec imSpec;
        InternalFormat.Spec reSpec;
        if (this.hasNoSpecType()) {
            reSpec = ComplexFormatter.getComponentSpecForNoSpecType(spec, '\uffff');
            imSpec = ComplexFormatter.getComponentSpecForNoSpecType(spec, '+');
        } else {
            reSpec = ComplexFormatter.getComponentSpec(spec, spec.sign);
            imSpec = ComplexFormatter.getComponentSpec(spec, '+');
        }
        this.reFormatter = new FloatFormatter(result, reSpec, false, raisingNode);
        this.imFormatter = new FloatFormatter(result, imSpec, false, raisingNode);
    }

    public ComplexFormatter(InternalFormat.Spec spec, Node raisingNode) {
        this(new FormattingBuffer.StringFormattingBuffer(32 + Math.max(0, spec.width)), spec, raisingNode);
    }

    private static InternalFormat.Spec getComponentSpec(InternalFormat.Spec spec, char sign) {
        return new InternalFormat.Spec('\u0000', '<', sign, spec.alternate, -1, spec.grouping, spec.precision, spec.type);
    }

    private static InternalFormat.Spec getComponentSpecForNoSpecType(InternalFormat.Spec spec, char sign) {
        int precision = spec.precision;
        char type = 'r';
        if (precision < 0) {
            precision = 0;
        } else {
            type = 'g';
        }
        return new InternalFormat.Spec(' ', '>', sign, false, -1, '\uffff', precision, type);
    }

    private boolean hasNoSpecType() {
        return this.spec.getType('\u0000') == '\u0000';
    }

    public ComplexFormatter format(double real, double imag) {
        this.setStart();
        boolean closeParen = false;
        if (this.hasNoSpecType()) {
            if (real == 0.0 && Math.copySign(1.0, real) == 1.0) {
                this.reFormatter.format(imag);
                this.result.append('j');
                return this;
            }
            this.result.append('(');
            closeParen = true;
        }
        this.reFormatter.format(real);
        this.imFormatter.format(imag);
        this.result.append('j');
        if (closeParen) {
            this.result.append(')');
        }
        return this;
    }
}

