/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.AttributeErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.lib.PyExceptionInstanceCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNodeGen;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline
@GenerateCached(value=false)
@GenerateUncached
public abstract class PRaiseNode
extends Node {
    protected abstract void executeEnterProfile(Node var1);

    @Specialization
    static void doProfile(Node inliningTarget, @Cached InlinedBranchProfile profile) {
        profile.enter(inliningTarget);
    }

    public final PException raise(Node inliningTarget, PythonBuiltinClassType type) {
        this.executeEnterProfile(inliningTarget);
        throw PRaiseNode.raiseStatic(inliningTarget, type);
    }

    public static PException raiseStatic(Node node, PythonBuiltinClassType type) {
        PythonLanguage language = PythonLanguage.get(node);
        PBaseException pythonException = PFactory.createBaseException(language, type);
        throw PRaiseNode.raiseExceptionObjectStatic(node, (Object)pythonException, language);
    }

    public final PException raise(Node inliningTarget, PythonBuiltinClassType type, TruffleString message) {
        this.executeEnterProfile(inliningTarget);
        throw PRaiseNode.raiseStatic(inliningTarget, type, message);
    }

    public static PException raiseStatic(Node node, PythonBuiltinClassType type, TruffleString message) {
        PythonLanguage language = PythonLanguage.get(node);
        PBaseException pythonException = PFactory.createBaseException(language, type, message);
        throw PRaiseNode.raiseExceptionObjectStatic(node, (Object)pythonException, language);
    }

    public final PException raise(Node inliningTarget, PythonBuiltinClassType type, TruffleString format, Object ... formatArgs) {
        this.executeEnterProfile(inliningTarget);
        throw PRaiseNode.raiseStatic(inliningTarget, type, format, formatArgs);
    }

    public static PException raiseStatic(Node node, PythonBuiltinClassType type, TruffleString message, Object ... formatArgs) {
        PythonLanguage language = PythonLanguage.get(node);
        PBaseException pythonException = PFactory.createBaseException(language, type, message, formatArgs);
        throw PRaiseNode.raiseExceptionObjectStatic(node, (Object)pythonException, language);
    }

    public final PException raise(Node inliningTarget, PythonBuiltinClassType type, Object[] arguments) {
        this.executeEnterProfile(inliningTarget);
        throw PRaiseNode.raiseStatic(inliningTarget, type, arguments);
    }

    public static PException raiseStatic(Node node, PythonBuiltinClassType type, Object[] arguments) {
        PythonLanguage language = PythonLanguage.get(node);
        PBaseException pythonException = PFactory.createBaseException(language, type, PFactory.createTuple(language, arguments));
        throw PRaiseNode.raiseExceptionObjectStatic(node, (Object)pythonException, language);
    }

    public final PException raiseWithData(Node inliningTarget, PythonBuiltinClassType type, Object[] data) {
        this.executeEnterProfile(inliningTarget);
        throw PRaiseNode.raiseWithDataStatic(inliningTarget, type, data);
    }

    public static PException raiseWithDataStatic(Node node, PythonBuiltinClassType type, Object[] data) {
        PythonLanguage language = PythonLanguage.get(node);
        PBaseException pythonException = PFactory.createBaseException(language, type, data, null);
        throw PRaiseNode.raiseExceptionObjectStatic(node, (Object)pythonException, language);
    }

    public final PException raiseAttributeError(Node inliningTarget, Object obj, Object key) {
        this.executeEnterProfile(inliningTarget);
        throw PRaiseNode.raiseAttributeErrorStatic(inliningTarget, obj, key);
    }

    public static PException raiseAttributeErrorStatic(Node inliningTarget, Object obj, Object key) {
        throw PRaiseNode.raiseWithDataStatic(inliningTarget, PythonBuiltinClassType.AttributeError, AttributeErrorBuiltins.dataForObjKey(obj, key), ErrorMessages.OBJ_P_HAS_NO_ATTR_S, obj, key);
    }

    public final PException raiseWithData(Node inliningTarget, PythonBuiltinClassType type, Object[] data, TruffleString format, Object ... formatArgs) {
        this.executeEnterProfile(inliningTarget);
        throw PRaiseNode.raiseWithDataStatic(inliningTarget, type, data, format, formatArgs);
    }

    public static PException raiseWithDataStatic(Node node, PythonBuiltinClassType type, Object[] data, TruffleString format, Object ... formatArgs) {
        PythonLanguage language = PythonLanguage.get(node);
        PBaseException pythonException = PFactory.createBaseException(language, type, data, format, formatArgs);
        throw PRaiseNode.raiseExceptionObjectStatic(node, (Object)pythonException, language);
    }

    public final PException raiseWithData(Node inliningTarget, PythonBuiltinClassType type, Object[] data, Object ... arguments) {
        this.executeEnterProfile(inliningTarget);
        throw PRaiseNode.raiseWithDataStatic(inliningTarget, type, data, arguments);
    }

    public static PException raiseWithDataStatic(Node node, PythonBuiltinClassType type, Object[] data, Object[] arguments) {
        PythonLanguage language = PythonLanguage.get(node);
        PBaseException pythonException = PFactory.createBaseException(language, type, data, PFactory.createTuple(language, arguments));
        throw PRaiseNode.raiseExceptionObjectStatic(node, (Object)pythonException, language);
    }

    public final PException raise(Node inliningTarget, PythonBuiltinClassType type, Exception e) {
        this.executeEnterProfile(inliningTarget);
        throw PRaiseNode.raiseStatic(inliningTarget, type, e);
    }

    public static PException raiseStatic(Node node, PythonBuiltinClassType type, Exception e) {
        PythonLanguage language = PythonLanguage.get(node);
        PBaseException pythonException = PFactory.createBaseException(language, type, ErrorMessages.M, new Object[]{e});
        throw PRaiseNode.raiseExceptionObjectStatic(node, (Object)pythonException, language);
    }

    private static void setCause(PBaseException pythonException, PException cause) {
        Object causePythonException = cause.getEscapedException();
        pythonException.setCause(causePythonException);
        pythonException.setContext(causePythonException);
    }

    public final PException raiseWithCause(Node inliningTarget, PythonBuiltinClassType type, PException cause, TruffleString format) {
        this.executeEnterProfile(inliningTarget);
        throw PRaiseNode.raiseWithCauseStatic(inliningTarget, type, cause, format);
    }

    public static PException raiseWithCauseStatic(Node node, PythonBuiltinClassType type, PException cause, TruffleString format) {
        PythonLanguage language = PythonLanguage.get(node);
        PBaseException pythonException = PFactory.createBaseException(language, type, format);
        PRaiseNode.setCause(pythonException, cause);
        throw PRaiseNode.raiseExceptionObjectStatic(node, (Object)pythonException, language);
    }

    public final PException raiseWithCause(Node inliningTarget, PythonBuiltinClassType type, PException cause, TruffleString format, Object ... arguments) {
        assert (PyExceptionInstanceCheckNode.executeUncached((Object)cause));
        this.executeEnterProfile(inliningTarget);
        throw PRaiseNode.raiseWithCauseStatic(inliningTarget, type, cause, format, arguments);
    }

    public static PException raiseWithCauseStatic(Node node, PythonBuiltinClassType type, PException cause, TruffleString format, Object ... formatArgs) {
        assert (PyExceptionInstanceCheckNode.executeUncached((Object)cause));
        PythonLanguage language = PythonLanguage.get(node);
        PBaseException pythonException = PFactory.createBaseException(language, type, format, formatArgs);
        PRaiseNode.setCause(pythonException, cause);
        throw PRaiseNode.raiseExceptionObjectStatic(node, (Object)pythonException, language);
    }

    public final PException raiseOverflow(Node inliningTarget) {
        throw this.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.CANNOT_FIT_P_INTO_INDEXSIZED_INT, 0);
    }

    public static PException raiseSystemExitStatic(Node inliningTarget, Object code) {
        throw PRaiseNode.raiseWithDataStatic(inliningTarget, PythonBuiltinClassType.SystemExit, new Object[]{code}, new Object[]{code});
    }

    public final PException raiseStopIteration(Node inliningTarget, Object value) {
        Object retVal = value != null ? value : PNone.NONE;
        Object[] args = new Object[]{retVal};
        throw this.raiseWithData(inliningTarget, PythonBuiltinClassType.StopIteration, args, retVal);
    }

    public final PException raiseStopAsyncIteration(Node inliningTarget, Object value) {
        Object retVal = value != null ? value : PNone.NONE;
        Object[] args = new Object[]{retVal};
        throw this.raiseWithData(inliningTarget, PythonBuiltinClassType.StopAsyncIteration, args, retVal);
    }

    public final PException raiseBadInternalCall(Node inliningTarget) {
        throw this.raise(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
    }

    public final PException raiseExceptionObject(Node raisingNode, Object exc) {
        throw PRaiseNode.raiseExceptionObjectStatic(raisingNode, exc);
    }

    public static PException raiseExceptionObjectStatic(Node raisingNode, Object exc) {
        throw PRaiseNode.raiseExceptionObjectStatic(raisingNode, exc, PythonOptions.isPExceptionWithJavaStacktrace(PythonLanguage.get(raisingNode)));
    }

    public static PException raiseExceptionObjectStatic(Node raisingNode, Object exc, PythonLanguage language) {
        throw PRaiseNode.raiseExceptionObjectStatic(raisingNode, exc, PythonOptions.isPExceptionWithJavaStacktrace(language));
    }

    public static PException raiseExceptionObjectStatic(Node raisingNode, Object exc, boolean withJavaStacktrace) {
        if (raisingNode != null && raisingNode.isAdoptable()) {
            throw PException.fromObject(exc, raisingNode, withJavaStacktrace);
        }
        throw PException.fromObject(exc, EncapsulatingNodeReference.getCurrent().get(), withJavaStacktrace);
    }

    public static PRaiseNode getUncached() {
        return PRaiseNodeGen.getUncached();
    }
}

