/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.rest;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.neuralsearch.transport.NeuralSparseClearCacheAction;
import org.opensearch.neuralsearch.transport.NeuralSparseClearCacheRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestNeuralSparseClearCacheHandler
extends BaseRestHandler {
    private static final String URL_PATH = "/clear_cache/{index}";
    public static String NAME = "neural_sparse_clear_cache_action";
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s%s", "/_plugins/_neural", URL_PATH)));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        NeuralSparseClearCacheRequest clearCacheRequest = this.createClearCacheRequest(request);
        return channel -> client.execute((ActionType)NeuralSparseClearCacheAction.INSTANCE, (ActionRequest)clearCacheRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private NeuralSparseClearCacheRequest createClearCacheRequest(RestRequest request) {
        String[] indexNames = Strings.splitStringByCommaToArray((String)request.param("index"));
        return new NeuralSparseClearCacheRequest(indexNames);
    }

    @Generated
    public RestNeuralSparseClearCacheHandler(ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }
}

