/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import org.jboss.logging.Logger;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityProviderMapper;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderMapperSyncMode;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public final class IdentityProviderMapperSyncModeDelegate {
    protected static final Logger logger = Logger.getLogger(IdentityProviderMapperSyncModeDelegate.class);

    public static void delegateUpdateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context, IdentityProviderMapper mapper) {
        IdentityProviderSyncMode effectiveSyncMode;
        IdentityProviderSyncMode idpSyncMode = context.getIdpConfig().getSyncMode();
        if (idpSyncMode == null) {
            idpSyncMode = IdentityProviderSyncMode.LEGACY;
        }
        if (!mapper.supportsSyncMode(effectiveSyncMode = IdentityProviderMapperSyncModeDelegate.combineIdpAndMapperSyncMode(idpSyncMode, mapperModel.getSyncMode()))) {
            logger.warnf("The mapper %s does not explicitly support sync mode %s. Please ensure that the SPI supports the sync mode correctly and update it to reflect this.", (Object)mapper.getDisplayType(), (Object)effectiveSyncMode);
        }
        if (effectiveSyncMode == IdentityProviderSyncMode.LEGACY) {
            mapper.updateBrokeredUserLegacy(session, realm, user, mapperModel, context);
        } else if (effectiveSyncMode == IdentityProviderSyncMode.FORCE) {
            mapper.updateBrokeredUser(session, realm, user, mapperModel, context);
        }
    }

    public static IdentityProviderSyncMode combineIdpAndMapperSyncMode(IdentityProviderSyncMode syncMode, IdentityProviderMapperSyncMode mapperSyncMode) {
        return IdentityProviderMapperSyncMode.INHERIT.equals((Object)mapperSyncMode) ? syncMode : IdentityProviderSyncMode.valueOf((String)mapperSyncMode.toString());
    }
}

