/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.runtime.JPAConfig;
import io.quarkus.hibernate.orm.runtime.RequestScopedSessionHolder;
import io.quarkus.hibernate.orm.runtime.RequestScopedStatelessSessionHolder;
import io.quarkus.hibernate.orm.runtime.session.TransactionScopedSession;
import io.quarkus.hibernate.orm.runtime.session.TransactionScopedStatelessSession;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.lang.annotation.Annotation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;

@ApplicationScoped
public class TransactionSessions {
    @Inject
    JPAConfig jpaConfig;
    @Inject
    Instance<RequestScopedSessionHolder> requestScopedSession;
    @Inject
    Instance<RequestScopedStatelessSessionHolder> requestScopedStatelessSession;
    private final ConcurrentMap<String, TransactionScopedSession> sessions = new ConcurrentHashMap<String, TransactionScopedSession>();
    private final ConcurrentMap<String, TransactionScopedStatelessSession> staleSessions = new ConcurrentHashMap<String, TransactionScopedStatelessSession>();

    public Session getSession(String unitName) {
        TransactionScopedSession session = (TransactionScopedSession)this.sessions.get(unitName);
        if (session != null) {
            return session;
        }
        return this.sessions.computeIfAbsent(unitName, un -> new TransactionScopedSession(this.getTransactionManager(), this.getTransactionSynchronizationRegistry(), (SessionFactory)this.jpaConfig.getEntityManagerFactory((String)un, false).unwrap(SessionFactory.class), (String)un, this.jpaConfig.getRequestScopedSessionEnabled(), this.requestScopedSession));
    }

    public StatelessSession getStatelessSession(String unitName) {
        TransactionScopedStatelessSession session = (TransactionScopedStatelessSession)this.staleSessions.get(unitName);
        if (session != null) {
            return session;
        }
        return this.staleSessions.computeIfAbsent(unitName, un -> new TransactionScopedStatelessSession(this.getTransactionManager(), this.getTransactionSynchronizationRegistry(), (SessionFactory)this.jpaConfig.getEntityManagerFactory((String)un, false).unwrap(SessionFactory.class), (String)un, this.jpaConfig.getRequestScopedSessionEnabled(), this.requestScopedStatelessSession));
    }

    private TransactionManager getTransactionManager() {
        return (TransactionManager)Arc.container().instance(TransactionManager.class, new Annotation[0]).get();
    }

    private TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return (TransactionSynchronizationRegistry)Arc.container().instance(TransactionSynchronizationRegistry.class, new Annotation[0]).get();
    }
}

