/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.converters.mutiny;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.reactivestreams.Publisher;

public class MultiConverter
implements ReactiveTypeConverter<Multi> {
    public <X> CompletionStage<X> toCompletionStage(Multi instance) {
        return instance.toUni().subscribeAsCompletionStage();
    }

    public <X> Publisher<X> toRSPublisher(Multi instance) {
        return AdaptersToReactiveStreams.publisher((Flow.Publisher)instance);
    }

    public <X> Flow.Publisher<X> toFlowPublisher(Multi instance) {
        return instance;
    }

    public <X> Multi fromCompletionStage(CompletionStage<X> cs) {
        return Multi.createFrom().completionStage(cs).onFailure(CompletionException.class).transform(Throwable::getCause);
    }

    public <X> Multi fromPublisher(Publisher<X> publisher) {
        return Multi.createFrom().publisher(AdaptersToFlow.publisher(publisher));
    }

    public <X> Multi fromFlowPublisher(Flow.Publisher<X> publisher) {
        return Multi.createFrom().publisher(publisher);
    }

    public Class<Multi> type() {
        return Multi.class;
    }

    public boolean emitItems() {
        return true;
    }

    public boolean emitAtMostOneItem() {
        return false;
    }

    public boolean supportNullValue() {
        return false;
    }
}

