/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.flow.adapters;

import java.util.Objects;
import java.util.concurrent.Flow;
import mutiny.zero.flow.adapters.common.Wrapper;
import mutiny.zero.flow.adapters.tors.ProcessorAdapterFromFlow;
import mutiny.zero.flow.adapters.tors.PublisherAdapterFromFlow;
import mutiny.zero.flow.adapters.tors.SubscriberAdapterFromFlow;
import mutiny.zero.flow.adapters.tors.SubscriptionAdapterFromFlow;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public interface AdaptersToReactiveStreams {
    public static <T> Publisher<T> publisher(Flow.Publisher<T> publisher) {
        Objects.requireNonNull(publisher, "The publisher must not be null");
        if (publisher instanceof Wrapper) {
            return (Publisher)((Wrapper)((Object)publisher)).unwrap();
        }
        return new PublisherAdapterFromFlow<T>(publisher);
    }

    public static <T> Subscriber<T> subscriber(Flow.Subscriber<T> subscriber) {
        Objects.requireNonNull(subscriber, "The subscriber must not be null");
        if (subscriber instanceof Wrapper) {
            return (Subscriber)((Wrapper)((Object)subscriber)).unwrap();
        }
        return new SubscriberAdapterFromFlow<T>(subscriber);
    }

    public static Subscription subscription(Flow.Subscription subscription) {
        Objects.requireNonNull(subscription, "The subscription must not be null");
        if (subscription instanceof Wrapper) {
            return (Subscription)((Wrapper)((Object)subscription)).unwrap();
        }
        return new SubscriptionAdapterFromFlow(subscription);
    }

    public static <T, R> Processor<T, R> processor(Flow.Processor<T, R> processor) {
        Objects.requireNonNull(processor, "The processor must not be null");
        if (processor instanceof Wrapper) {
            return (Processor)((Wrapper)((Object)processor)).unwrap();
        }
        return new ProcessorAdapterFromFlow<T, R>(processor);
    }
}

