/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.impl.analysis.InsertRequiredAttributeFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.htmltools.HtmlToolsBundle;
import com.intellij.htmltools.codeInspection.htmlInspections.InspectionUtils;
import com.intellij.htmltools.codeInspection.htmlInspections.htmlAddLabelToForm.CreateNewLabelAction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class HtmlRequiredTitleAttributeInspection
extends HtmlLocalInspectionTool {
    private static final Set<String> ourElementsWithoutTitle = Set.of("frame", "iframe", "dl", "a", "router-link");
    private static final String TITLE = "title";

    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            HtmlRequiredTitleAttributeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            HtmlRequiredTitleAttributeInspection.$$$reportNull$$$0(1);
        }
        if (!HtmlUtil.isHtmlTagContainingFile((PsiElement)tag)) {
            return;
        }
        String tagName = StringUtil.toLowerCase((String)tag.getName());
        if (ourElementsWithoutTitle.contains(tagName)) {
            XmlAttribute title = tag.getAttribute(TITLE);
            if (title != null) {
                return;
            }
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            if (!ourElementsWithoutTitle.contains(tag.getName())) {
                fixes.add(new CreateNewLabelAction(tag.getName()));
            }
            if (holder.isOnTheFly()) {
                fixes.add((LocalQuickFix)new InsertRequiredAttributeFix(tag, TITLE, new String[0]){

                    @NotNull
                    public String getText() {
                        String string = HtmlToolsBundle.message("html.intention.insert.attribute", HtmlRequiredTitleAttributeInspection.TITLE);
                        if (string == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredTitleAttributeInspection$1", "getText"));
                    }
                });
            }
            InspectionUtils.RegisterProblem(tag, holder, fixes, HtmlToolsBundle.message("html.inspections.check.required.title", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    @NotNull
    public String getShortName() {
        return "HtmlRequiredTitleAttribute";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "tag";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/htmltools/codeInspection/htmlInspections/HtmlRequiredTitleAttributeInspection";
        objectArray[2] = "checkTag";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

