/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.graph.curve.opengl.RegionRenderer;
import com.jogamp.graph.ui.shapes.TexSeqButton;
import com.jogamp.opengl.FBObject;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLOffscreenAutoDrawable;
import com.jogamp.opengl.util.texture.ImageSequence;
import com.jogamp.opengl.util.texture.Texture;

public class GLButton
extends TexSeqButton {
    private final GLEventListener glel;
    private final boolean useAlpha;
    private volatile int fboWidth = 200;
    private volatile int fboHeight = 200;
    private volatile GLOffscreenAutoDrawable.FBO fboGLAD = null;
    private boolean animateGLEL = false;

    public GLButton(int n, float f, float f2, int n2, GLEventListener gLEventListener, boolean bl) {
        super(n & 0xFFFFFFFC, f, f2, new ImageSequence(n2, true));
        this.glel = gLEventListener;
        this.useAlpha = bl;
        this.setColor(1.0f, 1.0f, 1.0f, 0.0f);
        this.setPressedColorMod(0.9f, 0.9f, 0.9f, 0.7f);
        this.setToggleOffColorMod(0.8f, 0.8f, 0.8f, 1.0f);
        this.setToggleOnColorMod(1.0f, 1.0f, 1.0f, 1.0f);
        this.fboWidth = 320;
        this.fboHeight = Math.round(640.0f * f2 / f);
    }

    public final void setAnimate(boolean bl) {
        this.animateGLEL = bl;
    }

    public final boolean getAnimate() {
        return this.animateGLEL;
    }

    public final void setFBOSize(int n, int n2) {
        this.fboWidth = n;
        this.fboHeight = n2;
    }

    public final GLOffscreenAutoDrawable.FBO getFBOAutoDrawable() {
        return this.fboGLAD;
    }

    @Override
    protected void destroyImpl(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        ((ImageSequence)this.texSeq).destroy(gL2ES2);
        this.fboGLAD.destroy();
    }

    @Override
    public void draw(GL2ES2 gL2ES2, RegionRenderer regionRenderer) {
        boolean bl;
        int[] nArray = this.getSurfaceSize(regionRenderer.getMatrix(), regionRenderer.getViewport(), new int[2]);
        boolean bl2 = bl = null != nArray && 0 < nArray[0] && 0 < nArray[1];
        if (null == this.fboGLAD) {
            ImageSequence imageSequence = (ImageSequence)this.texSeq;
            GLContext gLContext = gL2ES2.getContext();
            GLDrawable gLDrawable = gLContext.getGLDrawable();
            GLCapabilitiesImmutable gLCapabilitiesImmutable = gLDrawable.getRequestedGLCapabilities();
            GLCapabilities gLCapabilities = (GLCapabilities)gLCapabilitiesImmutable.cloneMutable();
            gLCapabilities.setFBO(true);
            gLCapabilities.setDoubleBuffered(false);
            if (!this.useAlpha) {
                gLCapabilities.setAlphaBits(0);
            }
            GLDrawableFactory gLDrawableFactory = GLDrawableFactory.getFactory(gLCapabilities.getGLProfile());
            if (bl) {
                this.fboWidth = nArray[0];
                this.fboHeight = nArray[1];
            }
            this.fboGLAD = (GLOffscreenAutoDrawable.FBO)gLDrawableFactory.createOffscreenAutoDrawable(gLDrawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice(), gLCapabilities, null, this.fboWidth, this.fboHeight);
            this.fboWidth = 0;
            this.fboHeight = 0;
            this.fboGLAD.setSharedContext(gLContext);
            this.fboGLAD.setTextureUnit(imageSequence.getTextureUnit());
            this.fboGLAD.addGLEventListener(this.glel);
            this.fboGLAD.display();
            FBObject.TextureAttachment textureAttachment = this.fboGLAD.getColorbuffer(1028).getTextureAttachment();
            Texture texture = new Texture(textureAttachment.getName(), false, imageSequence.getTextureTarget(), this.fboGLAD.getSurfaceWidth(), this.fboGLAD.getSurfaceHeight(), this.fboGLAD.getSurfaceWidth(), this.fboGLAD.getSurfaceHeight(), false);
            imageSequence.addFrame((GL)gL2ES2, texture);
            this.markStateDirty();
        } else if (0 != this.fboWidth * this.fboHeight) {
            this.fboGLAD.setSurfaceSize(this.fboWidth, this.fboHeight);
            this.fboWidth = 0;
            this.fboHeight = 0;
            this.markStateDirty();
        } else if (bl && (this.fboGLAD.getSurfaceWidth() != nArray[0] || this.fboGLAD.getSurfaceHeight() != nArray[1])) {
            ImageSequence imageSequence = (ImageSequence)this.texSeq;
            this.fboGLAD.setSurfaceSize(nArray[0], nArray[1]);
            this.fboGLAD.display();
            imageSequence.destroy(gL2ES2);
            FBObject.TextureAttachment textureAttachment = this.fboGLAD.getColorbuffer(1028).getTextureAttachment();
            Texture texture = new Texture(textureAttachment.getName(), false, imageSequence.getTextureTarget(), this.fboGLAD.getSurfaceWidth(), this.fboGLAD.getSurfaceHeight(), this.fboGLAD.getSurfaceWidth(), this.fboGLAD.getSurfaceHeight(), false);
            imageSequence.addFrame((GL)gL2ES2, texture);
            this.fboWidth = 0;
            this.fboHeight = 0;
            this.markStateDirty();
        } else if (this.animateGLEL) {
            this.fboGLAD.display();
        }
        super.draw(gL2ES2, regionRenderer);
        if (this.animateGLEL) {
            this.markStateDirty();
        }
    }
}

