/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hsqldb.model;

import java.sql.ResultSet;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericSynonym;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class HSQLSynonym
extends GenericSynonym {
    private static final Log log = Log.getLog(HSQLSynonym.class);
    private String targetSchemaName;
    private String targetObjectName;
    private String targetObjectType;

    protected HSQLSynonym(GenericStructContainer container, JDBCResultSet dbResult) {
        super(container, JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SYNONYM_NAME"), null);
        this.targetSchemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_SCHEMA");
        this.targetObjectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME");
        this.targetObjectType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_TYPE");
    }

    @Property(viewable=true, order=3)
    public String getTargetObjectType() {
        return this.targetObjectType;
    }

    @Property(viewable=true, order=4)
    public DBSObject getTargetObject(DBRProgressMonitor monitor) throws DBException {
        GenericSchema schema = this.getDataSource().getSchema(this.targetSchemaName);
        if (schema != null) {
            return schema.getTable(monitor, this.targetObjectName);
        }
        log.error((Object)("Schema '" + this.targetSchemaName + "' not found"));
        return null;
    }
}

