/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleParameterMode;
import org.jkiss.dbeaver.ext.oracle.model.OracleProcedureBase;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameterKind;
import org.jkiss.utils.CommonUtils;

public class OracleProcedureArgument
implements DBSProcedureParameter,
DBSTypedObject {
    private final OracleProcedureBase procedure;
    private String name;
    private int position;
    private int dataLevel;
    private int sequence;
    private OracleParameterMode mode;
    private OracleDataType type;
    private OracleDataType dataType;
    private String packageTypeName;
    private int dataLength;
    private int dataScale;
    private int dataPrecision;
    private List<OracleProcedureArgument> attributes;

    public OracleProcedureArgument(DBRProgressMonitor monitor, OracleProcedureBase procedure, ResultSet dbResult) {
        this.procedure = procedure;
        this.name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"ARGUMENT_NAME");
        this.position = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"POSITION");
        this.dataLevel = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DATA_LEVEL");
        this.sequence = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"SEQUENCE");
        this.mode = CommonUtils.isEmpty((String)this.name) ? OracleParameterMode.RETURN : OracleParameterMode.getMode(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IN_OUT"));
        String dataType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATA_TYPE");
        this.type = CommonUtils.isEmpty((String)dataType) ? null : OracleDataType.resolveDataType(monitor, procedure.getDataSource(), null, dataType);
        String typeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE_NAME");
        String typeOwner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE_OWNER");
        this.packageTypeName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE_SUBNAME");
        if (!CommonUtils.isEmpty((String)typeName) && !CommonUtils.isEmpty((String)typeOwner) && CommonUtils.isEmpty((String)this.packageTypeName)) {
            this.dataType = OracleDataType.resolveDataType(monitor, procedure.getDataSource(), typeOwner, typeName);
            if (this.dataType == null) {
                this.packageTypeName = typeOwner + "." + typeName;
            }
        } else if (this.packageTypeName != null) {
            this.packageTypeName = typeName + "." + this.packageTypeName;
        }
        this.dataLength = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DATA_LENGTH");
        this.dataScale = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DATA_SCALE");
        this.dataPrecision = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DATA_PRECISION");
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public OracleDataSource getDataSource() {
        return this.procedure.getDataSource();
    }

    public OracleProcedureBase getParentObject() {
        return this.procedure;
    }

    public boolean isPersisted() {
        return true;
    }

    @Property(viewable=true, order=10)
    @NotNull
    public String getName() {
        if (CommonUtils.isEmpty((String)this.name)) {
            if (this.dataLevel == 0) {
                return "RESULT";
            }
            return "ELEMENT";
        }
        return this.name;
    }

    public boolean isResultArgument() {
        return CommonUtils.isEmpty((String)this.name) && this.dataLevel == 0;
    }

    @Property(viewable=true, order=11)
    public int getPosition() {
        return this.position;
    }

    @Property(viewable=true, order=20)
    @NotNull
    public DBSProcedureParameterKind getParameterKind() {
        return this.mode == null ? DBSProcedureParameterKind.UNKNOWN : this.mode.getParameterKind();
    }

    @Property(viewable=true, order=21)
    public Object getType() {
        return this.packageTypeName != null ? this.packageTypeName : (this.dataType == null ? this.type : this.dataType);
    }

    @Property(viewable=true, order=30)
    public long getMaxLength() {
        return this.dataLength;
    }

    public long getTypeModifiers() {
        return 0L;
    }

    @NotNull
    public String getTypeName() {
        return this.type == null ? this.packageTypeName : this.type.getName();
    }

    @NotNull
    public String getFullTypeName() {
        return DBUtils.getFullTypeName((DBSTypedObject)this);
    }

    public int getTypeID() {
        return this.type == null ? 0 : this.type.getTypeID();
    }

    @NotNull
    public DBPDataKind getDataKind() {
        return this.type == null ? DBPDataKind.OBJECT : this.type.getDataKind();
    }

    @Property(viewable=true, order=40)
    @Nullable
    public Integer getScale() {
        return this.dataScale;
    }

    @Property(viewable=true, order=50)
    public Integer getPrecision() {
        return this.dataPrecision;
    }

    public int getDataLevel() {
        return this.dataLevel;
    }

    public int getSequence() {
        return this.sequence;
    }

    @Association
    public List<OracleProcedureArgument> getAttributes() {
        return this.attributes;
    }

    void addAttribute(OracleProcedureArgument attribute) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<OracleProcedureArgument>();
        }
        this.attributes.add(attribute);
    }

    public boolean hasAttributes() {
        return !CommonUtils.isEmpty(this.attributes);
    }

    @NotNull
    public DBSTypedObject getParameterType() {
        return this;
    }
}

