﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mq/MQ_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MQ {
namespace Model {
class DeleteConfigurationResult {
 public:
  AWS_MQ_API DeleteConfigurationResult() = default;
  AWS_MQ_API DeleteConfigurationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MQ_API DeleteConfigurationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The unique ID that Amazon MQ generates for the configuration.</p>
   */
  inline const Aws::String& GetConfigurationId() const { return m_configurationId; }
  template <typename ConfigurationIdT = Aws::String>
  void SetConfigurationId(ConfigurationIdT&& value) {
    m_configurationIdHasBeenSet = true;
    m_configurationId = std::forward<ConfigurationIdT>(value);
  }
  template <typename ConfigurationIdT = Aws::String>
  DeleteConfigurationResult& WithConfigurationId(ConfigurationIdT&& value) {
    SetConfigurationId(std::forward<ConfigurationIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteConfigurationResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_configurationId;

  Aws::String m_requestId;
  bool m_configurationIdHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MQ
}  // namespace Aws
