/// <reference types="node" />
import type * as http from 'http';
import type { AddRequestDataToEventOptions } from '@sentry/utils';
import type { ParseRequestOptions } from './requestDataDeprecated';
/**
 * Express-compatible tracing handler.
 * @see Exposed as `Handlers.tracingHandler`
 */
export declare function tracingHandler(): (req: http.IncomingMessage, res: http.ServerResponse, next: (error?: any) => void) => void;
export type RequestHandlerOptions = (ParseRequestOptions | AddRequestDataToEventOptions) & {
    flushTimeout?: number;
};
/**
 * Express compatible request handler.
 * @see Exposed as `Handlers.requestHandler`
 */
export declare function requestHandler(options?: RequestHandlerOptions): (req: http.IncomingMessage, res: http.ServerResponse, next: (error?: any) => void) => void;
/** JSDoc */
interface MiddlewareError extends Error {
    status?: number | string;
    statusCode?: number | string;
    status_code?: number | string;
    output?: {
        statusCode?: number | string;
    };
}
/**
 * Express compatible error handler.
 * @see Exposed as `Handlers.errorHandler`
 */
export declare function errorHandler(options?: {
    /**
     * Callback method deciding whether error should be captured and sent to Sentry
     * @param error Captured middleware error
     */
    shouldHandleError?(this: void, error: MiddlewareError): boolean;
}): (error: MiddlewareError, req: http.IncomingMessage, res: http.ServerResponse, next: (error: MiddlewareError) => void) => void;
interface SentryTrpcMiddlewareOptions {
    /** Whether to include procedure inputs in reported events. Defaults to `false`. */
    attachRpcInput?: boolean;
}
interface TrpcMiddlewareArguments<T> {
    path: string;
    type: string;
    next: () => T;
    rawInput: unknown;
}
/**
 * Sentry tRPC middleware that names the handling transaction after the called procedure.
 *
 * Use the Sentry tRPC middleware in combination with the Sentry server integration,
 * e.g. Express Request Handlers or Next.js SDK.
 */
export declare function trpcMiddleware(options?: SentryTrpcMiddlewareOptions): <T>({ path, type, next, rawInput }: TrpcMiddlewareArguments<T>) => T;
export type { ParseRequestOptions, ExpressRequest } from './requestDataDeprecated';
export { parseRequest, extractRequestData } from './requestDataDeprecated';
//# sourceMappingURL=handlers.d.ts.map