/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.java.decompiler.modules.decompiler.LowBreakHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SimplifyExprentsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchPatternHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;

public final class EliminateLoopsHelper {
    public static boolean eliminateLoops(RootStatement root, StructMethod mt, StructClass cl) {
        boolean ret = EliminateLoopsHelper.eliminateLoopsRec(root);
        if (ret) {
            SequenceHelper.condenseSequences(root);
            HashSet<Integer> setReorderedIfs = new HashSet<Integer>();
            SimplifyExprentsHelper sehelper = new SimplifyExprentsHelper(false);
            while (sehelper.simplifyStackVarsStatement(root, setReorderedIfs, null, cl)) {
                SequenceHelper.condenseSequences(root);
            }
        }
        return ret;
    }

    private static boolean eliminateLoopsRec(Statement stat) {
        for (Statement st : stat.getStats()) {
            if (!EliminateLoopsHelper.eliminateLoopsRec(st)) continue;
            return true;
        }
        return stat.type == Statement.StatementType.DO && EliminateLoopsHelper.findAndReduceRedundantLoop((DoStatement)stat);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean findAndReduceRedundantLoop(DoStatement loop) {
        SwitchStatement switchStatement;
        Statement parentloop;
        if (loop.getLoopType() != DoStatement.LoopType.DO) {
            return false;
        }
        for (parentloop = loop.getParent(); parentloop != null && parentloop.type != Statement.StatementType.DO; parentloop = parentloop.getParent()) {
        }
        if (parentloop == null || parentloop.getBasichead() != loop.getBasichead()) {
            return false;
        }
        ArrayList<StatEdge> lstBreakEdges = new ArrayList<StatEdge>();
        for (StatEdge edge2 : loop.getLabelEdges()) {
            if (edge2.getType() != StatEdge.EdgeType.BREAK) continue;
            lstBreakEdges.add(edge2);
        }
        Statement loopcontent = loop.getFirst();
        boolean firstok = loopcontent.getAllSuccessorEdges().isEmpty();
        if (loopcontent.type == Statement.StatementType.SWITCH && loopcontent instanceof SwitchStatement && (switchStatement = (SwitchStatement)loopcontent).getHeadExprent() != null && SwitchPatternHelper.isBootstrapSwitch(switchStatement.getHeadExprent())) {
            HashSet<StatEdge> allEdges = new HashSet<StatEdge>();
            for (Statement statement : switchStatement.getCaseStatements()) {
                allEdges.addAll(statement.getAllSuccessorEdges());
            }
            if (allEdges.stream().anyMatch(edge -> edge.closure.type == Statement.StatementType.DO)) {
                return false;
            }
        }
        if (!firstok) {
            StatEdge edge3 = loopcontent.getAllSuccessorEdges().get(0);
            boolean bl = firstok = edge3.closure == loop && edge3.getType() == StatEdge.EdgeType.BREAK;
            if (firstok) {
                lstBreakEdges.remove(edge3);
            }
        }
        if (!lstBreakEdges.isEmpty()) {
            if (firstok) {
                void var8_20;
                void var8_17;
                Statement st2;
                void var8_15;
                HashMap<Integer, Boolean> statLabeled = new HashMap<Integer, Boolean>();
                ArrayList<Statement> lstEdgeClosures = new ArrayList<Statement>();
                for (StatEdge statEdge : lstBreakEdges) {
                    Statement minclosure = LowBreakHelper.getMinClosure(loopcontent, statEdge.getSource());
                    lstEdgeClosures.add(minclosure);
                }
                int precount = loop.isLabeled() ? 1 : 0;
                for (Statement st2 : lstEdgeClosures) {
                    if (statLabeled.containsKey(st2.id)) continue;
                    boolean btemp = st2.isLabeled();
                    precount += btemp ? 1 : 0;
                    statLabeled.put(st2.id, btemp);
                }
                boolean bl = false;
                while (var8_15 < lstBreakEdges.size()) {
                    st2 = (Statement)lstEdgeClosures.get((int)var8_15);
                    statLabeled.put(st2.id, LowBreakHelper.isBreakEdgeLabeled(((StatEdge)lstBreakEdges.get((int)var8_15)).getSource(), st2) | statLabeled.get(st2.id));
                    ++var8_15;
                }
                boolean bl2 = false;
                while (var8_17 < lstBreakEdges.size()) {
                    lstEdgeClosures.set((int)var8_17, EliminateLoopsHelper.getMaxBreakLift((Statement)lstEdgeClosures.get((int)var8_17), (StatEdge)lstBreakEdges.get((int)var8_17), statLabeled, loop));
                    ++var8_17;
                }
                statLabeled.clear();
                for (Statement st2 : lstEdgeClosures) {
                    statLabeled.put(st2.id, st2.isLabeled());
                }
                boolean bl3 = false;
                while (var8_20 < lstBreakEdges.size()) {
                    st2 = (Statement)lstEdgeClosures.get((int)var8_20);
                    statLabeled.put(st2.id, LowBreakHelper.isBreakEdgeLabeled(((StatEdge)lstBreakEdges.get((int)var8_20)).getSource(), st2) | statLabeled.get(st2.id));
                    ++var8_20;
                }
                long l = statLabeled.values().stream().filter(Boolean::booleanValue).count();
                if ((long)precount <= l) {
                    return false;
                }
                for (int i3 = 0; i3 < lstBreakEdges.size(); ++i3) {
                    ((Statement)lstEdgeClosures.get(i3)).addLabeledEdge((StatEdge)lstBreakEdges.get(i3));
                }
            } else {
                return false;
            }
        }
        EliminateLoopsHelper.eliminateLoop(loop, parentloop);
        return true;
    }

    private static Statement getMaxBreakLift(Statement stat, StatEdge edge, HashMap<Integer, Boolean> statLabeled, Statement max) {
        Statement closure = stat;
        Statement newclosure = stat;
        while ((newclosure = EliminateLoopsHelper.getNextBreakLift(newclosure, edge, statLabeled, max)) != null) {
            closure = newclosure;
        }
        return closure;
    }

    private static Statement getNextBreakLift(Statement stat, StatEdge edge, HashMap<Integer, Boolean> statLabeled, Statement max) {
        for (Statement closure = stat.getParent(); closure != null && closure != max && !closure.containsStatementStrict(edge.getDestination()); closure = closure.getParent()) {
            boolean stat_labeled;
            boolean edge_labeled = LowBreakHelper.isBreakEdgeLabeled(edge.getSource(), closure);
            boolean bl = stat_labeled = statLabeled.containsKey(closure.id) ? statLabeled.get(closure.id).booleanValue() : closure.isLabeled();
            if (!stat_labeled && edge_labeled) continue;
            return closure;
        }
        return null;
    }

    private static void eliminateLoop(Statement loop, Statement parentloop) {
        Statement loopcontent = loop.getFirst();
        if (!loopcontent.getSuccessorEdges(StatEdge.EdgeType.BREAK).isEmpty()) {
            loopcontent.removeSuccessor(loopcontent.getSuccessorEdges(StatEdge.EdgeType.BREAK).get(0));
        }
        ArrayList<StatEdge> lst = new ArrayList<StatEdge>(loop.getLabelEdges());
        for (StatEdge edge : lst) {
            loop.removePredecessor(edge);
            edge.getSource().changeEdgeNode(StatEdge.EdgeDirection.FORWARD, edge, parentloop);
            parentloop.addPredecessor(edge);
            parentloop.addLabeledEdge(edge);
        }
        loop.getParent().replaceStatement(loop, loopcontent);
    }
}

