/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ec4j.core.model.Property;
import org.ec4j.core.model.PropertyType;

public class ResourceProperties {
    private final Map<String, Property> properties;

    public static Builder builder() {
        return new Builder();
    }

    ResourceProperties(Map<String, Property> properties) {
        this.properties = properties;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public <T> T getValue(PropertyType<T> type, T defaultValue, boolean throwInvalid) {
        return this.getValue(type.getName(), defaultValue, throwInvalid);
    }

    public <T> T getValue(String name, T defaultValue, boolean throwInvalid) {
        Property prop = this.properties.get(name);
        if (prop == null) {
            return defaultValue;
        }
        if (throwInvalid || prop.isValid()) {
            return prop.getValueAs();
        }
        return defaultValue;
    }

    public static class Builder {
        private final Map<String, Property> properties = new LinkedHashMap<String, Property>();

        public ResourceProperties build() {
            return new ResourceProperties(this.properties);
        }

        public Builder properties(Collection<Property> properties) {
            for (Property property : properties) {
                this.properties.put(property.getName(), property);
            }
            return this;
        }

        public Builder properties(Map<String, Property> properties) {
            this.properties.putAll(properties);
            return this;
        }

        public Builder properties(Property ... properties) {
            for (Property property : properties) {
                this.properties.put(property.getName(), property);
            }
            return this;
        }

        public Builder property(Property property) {
            this.properties.put(property.getName(), property);
            return this;
        }

        public Builder removeProperty(Property property) {
            this.properties.remove(property.getName());
            return this;
        }
    }
}

