/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.testng.ITestNGMethod;
import org.testng.internal.IParameterInfo;
import org.testng.internal.RuntimeBehavior;

public final class Systematiser {
    private static final Comparator<ITestNGMethod> COMPARE_INSTANCES = Comparator.comparingInt(ITestNGMethod::getPriority).thenComparing(method -> method.getRealClass().getName()).thenComparing(ITestNGMethod::getMethodName).thenComparing(Object::toString).thenComparing(method -> {
        IParameterInfo paramsInfo = method.getFactoryMethodParamsInfo();
        return paramsInfo == null ? "" : Arrays.toString(paramsInfo.getParameters());
    }).thenComparingInt(method -> Objects.hashCode(method.getInstance()));

    private Systematiser() {
    }

    public static Comparator<ITestNGMethod> getComparator() {
        Comparator<ITestNGMethod> comparator;
        String text = RuntimeBehavior.orderMethodsBasedOn();
        Order order = Order.parse(text);
        switch (order) {
            case METHOD_NAMES: {
                comparator = new Comparator<ITestNGMethod>(){

                    @Override
                    public int compare(ITestNGMethod o1, ITestNGMethod o2) {
                        String n1 = o1.getMethodName();
                        String n2 = o2.getMethodName();
                        return n1.compareTo(n2);
                    }

                    public String toString() {
                        return "Method_Names";
                    }
                };
                break;
            }
            case NONE: {
                comparator = new Comparator<ITestNGMethod>(){

                    @Override
                    public int compare(ITestNGMethod o1, ITestNGMethod o2) {
                        return 0;
                    }

                    public String toString() {
                        return "No_Sorting";
                    }
                };
                break;
            }
            default: {
                comparator = new Comparator<ITestNGMethod>(){

                    @Override
                    public int compare(ITestNGMethod o1, ITestNGMethod o2) {
                        return COMPARE_INSTANCES.compare(o1, o2);
                    }

                    public String toString() {
                        return "Instance_Names";
                    }
                };
            }
        }
        return comparator;
    }

    static enum Order {
        METHOD_NAMES("methods"),
        INSTANCES("instances"),
        NONE("none");

        private final String value;

        private Order(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Order parse(String value) {
            if (value == null || value.trim().isEmpty()) {
                return INSTANCES;
            }
            for (Order each : Order.values()) {
                if (!each.getValue().equalsIgnoreCase(value)) continue;
                return each;
            }
            return INSTANCES;
        }
    }
}

