//
// Copyright 2025 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/usdImaging/usdSkelImaging/blendShapeSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(UsdSkelImagingBlendShapeSchemaTokens,
    USD_SKEL_IMAGING_BLEND_SHAPE_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdVec3fArrayDataSourceHandle
UsdSkelImagingBlendShapeSchema::GetOffsets() const
{
    return _GetTypedDataSource<HdVec3fArrayDataSource>(
        UsdSkelImagingBlendShapeSchemaTokens->offsets);
}

HdVec3fArrayDataSourceHandle
UsdSkelImagingBlendShapeSchema::GetNormalOffsets() const
{
    return _GetTypedDataSource<HdVec3fArrayDataSource>(
        UsdSkelImagingBlendShapeSchemaTokens->normalOffsets);
}

HdIntArrayDataSourceHandle
UsdSkelImagingBlendShapeSchema::GetPointIndices() const
{
    return _GetTypedDataSource<HdIntArrayDataSource>(
        UsdSkelImagingBlendShapeSchemaTokens->pointIndices);
}

UsdSkelImagingInbetweenShapeContainerSchema
UsdSkelImagingBlendShapeSchema::GetInbetweenShapes() const
{
    return UsdSkelImagingInbetweenShapeContainerSchema(_GetTypedDataSource<HdContainerDataSource>(
        UsdSkelImagingBlendShapeSchemaTokens->inbetweenShapes));
}

/*static*/
HdContainerDataSourceHandle
UsdSkelImagingBlendShapeSchema::BuildRetained(
        const HdVec3fArrayDataSourceHandle &offsets,
        const HdVec3fArrayDataSourceHandle &normalOffsets,
        const HdIntArrayDataSourceHandle &pointIndices,
        const HdContainerDataSourceHandle &inbetweenShapes
)
{
    TfToken _names[4];
    HdDataSourceBaseHandle _values[4];

    size_t _count = 0;

    if (offsets) {
        _names[_count] = UsdSkelImagingBlendShapeSchemaTokens->offsets;
        _values[_count++] = offsets;
    }

    if (normalOffsets) {
        _names[_count] = UsdSkelImagingBlendShapeSchemaTokens->normalOffsets;
        _values[_count++] = normalOffsets;
    }

    if (pointIndices) {
        _names[_count] = UsdSkelImagingBlendShapeSchemaTokens->pointIndices;
        _values[_count++] = pointIndices;
    }

    if (inbetweenShapes) {
        _names[_count] = UsdSkelImagingBlendShapeSchemaTokens->inbetweenShapes;
        _values[_count++] = inbetweenShapes;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

UsdSkelImagingBlendShapeSchema::Builder &
UsdSkelImagingBlendShapeSchema::Builder::SetOffsets(
    const HdVec3fArrayDataSourceHandle &offsets)
{
    _offsets = offsets;
    return *this;
}

UsdSkelImagingBlendShapeSchema::Builder &
UsdSkelImagingBlendShapeSchema::Builder::SetNormalOffsets(
    const HdVec3fArrayDataSourceHandle &normalOffsets)
{
    _normalOffsets = normalOffsets;
    return *this;
}

UsdSkelImagingBlendShapeSchema::Builder &
UsdSkelImagingBlendShapeSchema::Builder::SetPointIndices(
    const HdIntArrayDataSourceHandle &pointIndices)
{
    _pointIndices = pointIndices;
    return *this;
}

UsdSkelImagingBlendShapeSchema::Builder &
UsdSkelImagingBlendShapeSchema::Builder::SetInbetweenShapes(
    const HdContainerDataSourceHandle &inbetweenShapes)
{
    _inbetweenShapes = inbetweenShapes;
    return *this;
}

HdContainerDataSourceHandle
UsdSkelImagingBlendShapeSchema::Builder::Build()
{
    return UsdSkelImagingBlendShapeSchema::BuildRetained(
        _offsets,
        _normalOffsets,
        _pointIndices,
        _inbetweenShapes
    );
}

/*static*/
UsdSkelImagingBlendShapeSchema
UsdSkelImagingBlendShapeSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return UsdSkelImagingBlendShapeSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                UsdSkelImagingBlendShapeSchemaTokens->skelBlendShape))
        : nullptr);
}

/*static*/
const TfToken &
UsdSkelImagingBlendShapeSchema::GetSchemaToken()
{
    return UsdSkelImagingBlendShapeSchemaTokens->skelBlendShape;
}

/*static*/
const HdDataSourceLocator &
UsdSkelImagingBlendShapeSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingBlendShapeSchema::GetOffsetsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingBlendShapeSchemaTokens->offsets);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingBlendShapeSchema::GetNormalOffsetsLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingBlendShapeSchemaTokens->normalOffsets);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingBlendShapeSchema::GetPointIndicesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingBlendShapeSchemaTokens->pointIndices);
    return locator;
}

/* static */
const HdDataSourceLocator &
UsdSkelImagingBlendShapeSchema::GetInbetweenShapesLocator()
{
    static const HdDataSourceLocator locator =
        GetDefaultLocator().Append(
            UsdSkelImagingBlendShapeSchemaTokens->inbetweenShapes);
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE
